/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import javax.transaction.xa.XAResource;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.ReadTransaction;
import org.neo4j.kernel.impl.nioneo.xa.WriteTransaction;
import org.neo4j.kernel.impl.persistence.NeoStoreTransaction;
import org.neo4j.kernel.impl.persistence.PersistenceSource;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class NioNeoDbPersistenceSource
implements PersistenceSource {
    private static final String MODULE_NAME = "NioNeoDbPersistenceSource";
    private NeoStoreXaDataSource xaDs = null;
    private String dataSourceName = null;
    private NeoStoreTransaction readOnlyResourceConnection;

    public synchronized void init() {
    }

    public synchronized void start(XaDataSourceManager xaDsManager) {
        this.xaDs = (NeoStoreXaDataSource)xaDsManager.getXaDataSource("nioneodb");
        if (this.xaDs == null) {
            throw new IllegalStateException("Unable to get nioneodb datasource");
        }
        this.readOnlyResourceConnection = new ReadTransaction(this.xaDs.getNeoStore());
    }

    public synchronized void reload() {
    }

    public synchronized void stop() {
        if (this.xaDs != null) {
            this.xaDs.close();
        }
    }

    public synchronized void destroy() {
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public NeoStoreTransaction createTransaction(XaConnection connection) {
        if (this.xaDs.isReadOnly()) {
            throw new ReadOnlyDbException();
        }
        WriteTransaction result = ((NeoStoreXaConnection)connection).getWriteTransaction();
        result.setXaConnection(connection);
        return result;
    }

    public NeoStoreTransaction createReadOnlyResourceConnection() {
        return this.readOnlyResourceConnection;
    }

    public String toString() {
        return "A persistence source to [" + this.dataSourceName + "]";
    }

    @Override
    public long nextId(Class<?> clazz) {
        return this.xaDs.nextId(clazz);
    }

    public XAResource getXaResource() {
        return this.xaDs.getXaConnection().getXaResource();
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public long getHighestPossibleIdInUse(Class<?> clazz) {
        return this.xaDs.getHighestPossibleIdInUse(clazz);
    }

    @Override
    public long getNumberOfIdsInUse(Class<?> clazz) {
        return this.xaDs.getNumberOfIdsInUse(clazz);
    }

    @Override
    public XaDataSource getXaDataSource() {
        return this.xaDs;
    }
}

