/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyDynamicRecordFetcher;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyDynamicStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyIndexStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyPropertyStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipTypeStoreReader;

public class LegacyStore {
    public static final String FROM_VERSION = "NeoStore v0.9.9";
    private String storageFileName;
    private LegacyPropertyStoreReader propertyStoreReader;
    private LegacyNodeStoreReader nodeStoreReader;
    private LegacyDynamicRecordFetcher dynamicRecordFetcher;
    private LegacyPropertyIndexStoreReader propertyIndexStoreReader;
    private LegacyDynamicStoreReader propertyIndexKeyStoreReader;
    private LegacyRelationshipStoreReader relationshipStoreReader;
    private LegacyRelationshipTypeStoreReader relationshipTypeStoreReader;
    private LegacyDynamicStoreReader relationshipTypeNameStoreReader;

    public LegacyStore(String storageFileName) throws IOException {
        this.storageFileName = storageFileName;
        this.initStorage();
    }

    protected void initStorage() throws IOException {
        this.propertyStoreReader = new LegacyPropertyStoreReader(this.getStorageFileName() + ".propertystore.db");
        this.dynamicRecordFetcher = new LegacyDynamicRecordFetcher(this.getStorageFileName() + ".propertystore.db.strings", this.getStorageFileName() + ".propertystore.db.arrays");
        this.nodeStoreReader = new LegacyNodeStoreReader(this.getStorageFileName() + ".nodestore.db");
        this.relationshipStoreReader = new LegacyRelationshipStoreReader(this.getStorageFileName() + ".relationshipstore.db");
        this.relationshipTypeStoreReader = new LegacyRelationshipTypeStoreReader(this.getStorageFileName() + ".relationshiptypestore.db");
        this.relationshipTypeNameStoreReader = new LegacyDynamicStoreReader(this.getStorageFileName() + ".relationshiptypestore.db.names", "StringPropertyStore v0.9.9");
        this.propertyIndexStoreReader = new LegacyPropertyIndexStoreReader(this.getStorageFileName() + ".propertystore.db.index");
        this.propertyIndexKeyStoreReader = new LegacyDynamicStoreReader(this.getStorageFileName() + ".propertystore.db.index.keys", "StringPropertyStore v0.9.9");
    }

    public String getStorageFileName() {
        return this.storageFileName;
    }

    public LegacyPropertyStoreReader getPropertyStoreReader() {
        return this.propertyStoreReader;
    }

    public LegacyNodeStoreReader getNodeStoreReader() {
        return this.nodeStoreReader;
    }

    public LegacyRelationshipStoreReader getRelationshipStoreReader() {
        return this.relationshipStoreReader;
    }

    public LegacyDynamicRecordFetcher getDynamicRecordFetcher() {
        return this.dynamicRecordFetcher;
    }

    public LegacyPropertyIndexStoreReader getPropertyIndexStoreReader() {
        return this.propertyIndexStoreReader;
    }

    public LegacyDynamicStoreReader getPropertyIndexKeyStoreReader() {
        return this.propertyIndexKeyStoreReader;
    }

    public LegacyDynamicStoreReader getRelationshipTypeNameStoreReader() {
        return this.relationshipTypeNameStoreReader;
    }

    public static long getUnsignedInt(ByteBuffer buf) {
        return (long)buf.getInt() & 0xFFFFFFFFL;
    }

    protected static long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }

    public LegacyRelationshipTypeStoreReader getRelationshipTypeStoreReader() {
        return this.relationshipTypeStoreReader;
    }
}

