/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.nio.channels.FileChannel;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Settings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPool;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public class DefaultWindowPoolFactory
implements WindowPoolFactory {
    @Override
    public WindowPool create(File storageFileName, int recordSize, FileChannel fileChannel, Config configuration, StringLogger log) {
        return new PersistenceWindowPool(storageFileName, recordSize, fileChannel, this.calculateMappedMemory(configuration, storageFileName), GraphDatabaseSettings.UseMemoryMappedBuffers.shouldMemoryMap(configuration.get(CommonAbstractStore.Configuration.use_memory_mapped_buffers)), this.isReadOnly(configuration) && !this.isBackupSlave(configuration), log);
    }

    private boolean isBackupSlave(Config configuration) {
        return configuration.get(CommonAbstractStore.Configuration.backup_slave);
    }

    private boolean isReadOnly(Config configuration) {
        return configuration.get(CommonAbstractStore.Configuration.read_only);
    }

    private long calculateMappedMemory(Config config, File storageFileName) {
        String realName = storageFileName.getName();
        Long mem = config.get(Settings.setting(realName + ".mapped_memory", Settings.BYTES, Settings.NO_DEFAULT));
        if (mem == null) {
            mem = 0L;
        }
        return mem;
    }
}

