/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.kernel.impl.util.StringLogger;

public class LegacyNeoStoreReader {
    private static final int RECORD_LENGTH = 9;
    private final FileChannel fileChannel;
    private final PersistenceWindowPool windowPool;

    public LegacyNeoStoreReader(FileSystemAbstraction fs, File fileName, StringLogger log) throws IOException {
        this.fileChannel = fs.open(fileName, "r");
        this.windowPool = new PersistenceWindowPool(fileName, 9, this.fileChannel, 0L, true, true, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRecord(long id) {
        PersistenceWindow window = this.windowPool.acquire(id, OperationType.READ);
        try {
            Buffer buffer = window.getOffsettedBuffer(id);
            buffer.get();
            long l = buffer.getLong();
            return l;
        }
        finally {
            this.windowPool.release(window);
        }
    }

    public long getCreationTime() {
        return this.getRecord(0L);
    }

    public long getRandomNumber() {
        return this.getRecord(1L);
    }

    public long getVersion() {
        return this.getRecord(2L);
    }

    public long getLastCommittedTx() {
        return this.getRecord(3L);
    }

    public void close() throws IOException {
        this.fileChannel.close();
    }
}

