/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.LogFiles;
import org.neo4j.kernel.impl.storemigration.StoreFiles;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;

public class DatabaseFiles {
    private final FileSystemAbstraction fs;

    public DatabaseFiles(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    public void moveToBackupDirectory(File workingDirectory, File backupDirectory) {
        if (this.fs.fileExists(backupDirectory)) {
            throw new StoreUpgrader.UnableToUpgradeException(String.format("Cannot proceed with upgrade because there is an existing upgrade backup in the way at %s. If you do not need this backup please delete it or move it out of the way before re-attempting upgrade.", backupDirectory.getAbsolutePath()));
        }
        this.fs.mkdir(backupDirectory);
        this.move(workingDirectory, backupDirectory);
    }

    public void moveToWorkingDirectory(File upgradeDirectory, File workingDirectory) {
        this.move(upgradeDirectory, workingDirectory);
    }

    private void move(File fromDirectory, File toDirectory) {
        try {
            StoreFiles.move(this.fs, fromDirectory, toDirectory);
            LogFiles.move(this.fs, fromDirectory, toDirectory);
        }
        catch (IOException e) {
            throw new StoreUpgrader.UnableToUpgradeException(e);
        }
    }
}

