/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.configuration.BaseConfigurationMigrator;
import org.neo4j.kernel.configuration.Settings;

public class GraphDatabaseConfigurationMigrator
extends BaseConfigurationMigrator {
    public GraphDatabaseConfigurationMigrator() {
        this.registerMigrations();
    }

    private void registerMigrations() {
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("dbms.index_sampling.buffer_size", "dbms.index_sampling.buffer_size has been replaced with dbms.index_sampling.sample_size_limit"){

            @Override
            public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
                if (StringUtils.isNotEmpty((CharSequence)value)) {
                    String oldSettingDefaultValue = GraphDatabaseSettings.index_sampling_buffer_size.getDefaultValue();
                    Long newValue = oldSettingDefaultValue.equals(value) ? Long.valueOf(ByteUnit.mebiBytes((long)8L)) : Settings.BYTES.apply(value);
                    rawConfiguration.put("dbms.index_sampling.sample_size_limit", String.valueOf(newValue));
                }
            }
        });
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("unsupported.dbms.executiontime_limit.time", "unsupported.dbms.executiontime_limit.time has been replaced with dbms.transaction.timeout."){

            @Override
            public void setValueWithOldSetting(String value, Map<String, String> rawConfiguration) {
                if (StringUtils.isNotEmpty((CharSequence)value)) {
                    rawConfiguration.putIfAbsent(GraphDatabaseSettings.transaction_timeout.name(), value);
                }
            }
        });
    }
}

