/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;

class KernelTransactionImplementationHandle
implements KernelTransactionHandle {
    private final long txReuseCount;
    private final long lastTransactionIdWhenStarted;
    private final long lastTransactionTimestampWhenStarted;
    private final long startTime;
    private final KernelTransactionImplementation tx;

    KernelTransactionImplementationHandle(KernelTransactionImplementation tx) {
        this.txReuseCount = tx.getReuseCount();
        this.lastTransactionIdWhenStarted = tx.lastTransactionIdWhenStarted();
        this.lastTransactionTimestampWhenStarted = tx.lastTransactionTimestampWhenStarted();
        this.startTime = tx.startTime();
        this.tx = tx;
    }

    @Override
    public long lastTransactionIdWhenStarted() {
        return this.lastTransactionIdWhenStarted;
    }

    @Override
    public long lastTransactionTimestampWhenStarted() {
        return this.lastTransactionTimestampWhenStarted;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public boolean isOpen() {
        return this.tx.isOpen() && this.txReuseCount == (long)this.tx.getReuseCount();
    }

    @Override
    public void markForTermination(Status reason) {
        this.tx.markForTermination(this.txReuseCount, reason);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KernelTransactionImplementationHandle that = (KernelTransactionImplementationHandle)o;
        return this.txReuseCount == that.txReuseCount && this.tx.equals(that.tx);
    }

    public int hashCode() {
        return 31 * (int)(this.txReuseCount ^ this.txReuseCount >>> 32) + this.tx.hashCode();
    }

    public String toString() {
        return "KernelTransactionImplementationHandle{txReuseCount=" + this.txReuseCount + ", tx=" + this.tx + "}";
    }
}

