/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.LongerShortString;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.string.UTF8;

public class PropertyStore
extends CommonAbstractStore<PropertyRecord, NoStoreHeader> {
    public static final String TYPE_DESCRIPTOR = "PropertyStore";
    private final DynamicStringStore stringStore;
    private final PropertyKeyTokenStore propertyKeyTokenStore;
    private final DynamicArrayStore arrayStore;

    public PropertyStore(File fileName, Config configuration, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, DynamicStringStore stringPropertyStore, PropertyKeyTokenStore propertyKeyTokenStore, DynamicArrayStore arrayPropertyStore, RecordFormats recordFormats, OpenOption ... openOptions) {
        super(fileName, configuration, IdType.PROPERTY, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, recordFormats.property(), NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, recordFormats.storeVersion(), openOptions);
        this.stringStore = stringPropertyStore;
        this.propertyKeyTokenStore = propertyKeyTokenStore;
        this.arrayStore = arrayPropertyStore;
    }

    @Override
    public <FAILURE extends Exception> void accept(RecordStore.Processor<FAILURE> processor, PropertyRecord record) throws FAILURE {
        processor.processProperty(this, record);
    }

    public DynamicStringStore getStringStore() {
        return this.stringStore;
    }

    public DynamicArrayStore getArrayStore() {
        return this.arrayStore;
    }

    public PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return this.propertyKeyTokenStore;
    }

    @Override
    public void updateRecord(PropertyRecord record) {
        this.updatePropertyBlocks(record);
        super.updateRecord(record);
    }

    private void updatePropertyBlocks(PropertyRecord record) {
        if (record.inUse()) {
            for (PropertyBlock block : record) {
                if (block.isLight() || !block.getValueRecords().get(0).isCreated()) continue;
                this.updateDynamicRecords(block.getValueRecords());
            }
        }
        this.updateDynamicRecords(record.getDeletedRecords());
    }

    private void updateDynamicRecords(List<DynamicRecord> records) {
        for (DynamicRecord valueRecord : records) {
            PropertyType recordType = valueRecord.getType();
            if (recordType == PropertyType.STRING) {
                this.stringStore.updateRecord(valueRecord);
                continue;
            }
            if (recordType == PropertyType.ARRAY) {
                this.arrayStore.updateRecord(valueRecord);
                continue;
            }
            throw new InvalidRecordException("Unknown dynamic record" + valueRecord);
        }
    }

    @Override
    public void ensureHeavy(PropertyRecord record) {
        for (PropertyBlock block : record) {
            this.ensureHeavy(block);
        }
    }

    @Override
    public void ensureHeavy(PropertyBlock block) {
        if (!block.isLight()) {
            return;
        }
        PropertyType type = block.getType();
        RecordStore<DynamicRecord> dynamicStore = this.dynamicStoreForValueType(type);
        if (dynamicStore == null) {
            return;
        }
        try (RecordCursor<DynamicRecord> dynamicRecords = dynamicStore.newRecordCursor(dynamicStore.newRecord()).acquire(block.getSingleValueLong(), RecordLoad.NORMAL);){
            while (dynamicRecords.next()) {
                ((DynamicRecord)dynamicRecords.get()).setType(type.intValue());
                block.addValueRecord(((DynamicRecord)dynamicRecords.get()).clone());
            }
        }
    }

    private RecordStore<DynamicRecord> dynamicStoreForValueType(PropertyType type) {
        switch (type) {
            case ARRAY: {
                return this.arrayStore;
            }
            case STRING: {
                return this.stringStore;
            }
        }
        return null;
    }

    public Object getValue(PropertyBlock propertyBlock) {
        return propertyBlock.getType().getValue(propertyBlock, this);
    }

    public static void allocateStringRecords(Collection<DynamicRecord> target, byte[] chars, DynamicRecordAllocator allocator) {
        AbstractDynamicStore.allocateRecordsFromBytes(target, chars, (Iterator<DynamicRecord>)Iterators.emptyIterator(), allocator);
    }

    public static void allocateArrayRecords(Collection<DynamicRecord> target, Object array, DynamicRecordAllocator allocator) {
        DynamicArrayStore.allocateRecords(target, array, (Iterator<DynamicRecord>)Iterators.emptyIterator(), allocator);
    }

    public void encodeValue(PropertyBlock block, int keyId, Object value) {
        PropertyStore.encodeValue(block, keyId, value, this.stringStore, this.arrayStore);
    }

    public static void encodeValue(PropertyBlock block, int keyId, Object value, DynamicRecordAllocator stringAllocator, DynamicRecordAllocator arrayAllocator) {
        if (value instanceof String) {
            String string = (String)value;
            if (LongerShortString.encode(keyId, string, block, PropertyType.getPayloadSize())) {
                return;
            }
            byte[] encodedString = PropertyStore.encodeString(string);
            ArrayList<DynamicRecord> valueRecords = new ArrayList<DynamicRecord>();
            PropertyStore.allocateStringRecords(valueRecords, encodedString, stringAllocator);
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.STRING, ((DynamicRecord)Iterables.first(valueRecords)).getId());
            for (DynamicRecord valueRecord : valueRecords) {
                valueRecord.setType(PropertyType.STRING.intValue());
            }
            block.setValueRecords(valueRecords);
        } else if (value instanceof Integer) {
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.INT, ((Integer)value).longValue());
        } else if (value instanceof Boolean) {
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.BOOL, (Boolean)value != false ? 1L : 0L);
        } else if (value instanceof Float) {
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.FLOAT, Float.floatToRawIntBits(((Float)value).floatValue()));
        } else if (value instanceof Long) {
            long keyAndType = (long)keyId | (long)PropertyType.LONG.intValue() << 24;
            if (ShortArray.LONG.getRequiredBits((Long)value) <= 35) {
                block.setSingleBlock(keyAndType | 0x10000000L | (Long)value << 29);
            } else {
                block.setValueBlocks(new long[]{keyAndType, (Long)value});
            }
        } else if (value instanceof Double) {
            block.setValueBlocks(new long[]{(long)keyId | (long)PropertyType.DOUBLE.intValue() << 24, Double.doubleToRawLongBits((Double)value)});
        } else if (value instanceof Byte) {
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.BYTE, ((Byte)value).longValue());
        } else if (value instanceof Character) {
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.CHAR, ((Character)value).charValue());
        } else if (value instanceof Short) {
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.SHORT, ((Short)value).longValue());
        } else if (value.getClass().isArray()) {
            if (ShortArray.encode(keyId, value, block, PropertyType.getPayloadSize())) {
                return;
            }
            ArrayList<DynamicRecord> arrayRecords = new ArrayList<DynamicRecord>();
            PropertyStore.allocateArrayRecords(arrayRecords, value, arrayAllocator);
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.ARRAY, ((DynamicRecord)Iterables.first(arrayRecords)).getId());
            for (DynamicRecord valueRecord : arrayRecords) {
                valueRecord.setType(PropertyType.ARRAY.intValue());
            }
            block.setValueRecords(arrayRecords);
        } else {
            throw new IllegalArgumentException("Unknown property type on: " + value + ", " + value.getClass());
        }
    }

    public static void setSingleBlockValue(PropertyBlock block, int keyId, PropertyType type, long longValue) {
        block.setSingleBlock(PropertyStore.singleBlockLongValue(keyId, type, longValue));
    }

    public static long singleBlockLongValue(int keyId, PropertyType type, long longValue) {
        return (long)keyId | (long)type.intValue() << 24 | longValue << 28;
    }

    public static byte[] encodeString(String string) {
        return UTF8.encode((String)string);
    }

    public static String decodeString(byte[] byteArray) {
        return UTF8.decode((byte[])byteArray);
    }

    public String getStringFor(PropertyBlock propertyBlock) {
        this.ensureHeavy(propertyBlock);
        return this.getStringFor(propertyBlock.getValueRecords());
    }

    public String getStringFor(Collection<DynamicRecord> dynamicRecords) {
        Pair<byte[], byte[]> source = this.stringStore.readFullByteArray(dynamicRecords, PropertyType.STRING);
        return PropertyStore.decodeString((byte[])source.other());
    }

    public Object getArrayFor(PropertyBlock propertyBlock) {
        this.ensureHeavy(propertyBlock);
        return this.getArrayFor(propertyBlock.getValueRecords());
    }

    public Object getArrayFor(Iterable<DynamicRecord> records) {
        return DynamicArrayStore.getRightArray(this.arrayStore.readFullByteArray(records, PropertyType.ARRAY));
    }

    @Override
    public String toString() {
        return super.toString() + "[blocksPerRecord:" + PropertyType.getPayloadSizeLongs() + "]";
    }

    public Collection<PropertyRecord> getPropertyRecordChain(long firstRecordId) {
        long nextProp = firstRecordId;
        LinkedList<PropertyRecord> toReturn = new LinkedList<PropertyRecord>();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = new PropertyRecord(nextProp);
            this.getRecord(nextProp, propRecord, RecordLoad.NORMAL);
            toReturn.add(propRecord);
            nextProp = propRecord.getNextProp();
        }
        return toReturn;
    }

    public Collection<PropertyRecord> getPropertyRecordChain(long firstRecordId, PrimitiveLongObjectMap<PropertyRecord> propertyLookup) {
        long nextProp = firstRecordId;
        ArrayList<PropertyRecord> toReturn = new ArrayList<PropertyRecord>();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = (PropertyRecord)propertyLookup.get(nextProp);
            if (propRecord == null) {
                propRecord = this.newRecord();
                this.getRecord(nextProp, propRecord, RecordLoad.NORMAL);
            }
            toReturn.add(propRecord);
            nextProp = propRecord.getNextProp();
        }
        return toReturn;
    }

    @Override
    public PropertyRecord newRecord() {
        return new PropertyRecord(-1L);
    }

    public static abstract class Configuration
    extends CommonAbstractStore.Configuration {
    }
}

