/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.impl.transaction.log.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;

public final class EntryTimespanThreshold
implements Threshold {
    private final long timeToKeepInMillis;
    private final Clock clock;
    private long lowerLimit;

    EntryTimespanThreshold(Clock clock, TimeUnit timeUnit, long timeToKeep) {
        this.clock = clock;
        this.timeToKeepInMillis = timeUnit.toMillis(timeToKeep);
    }

    @Override
    public void init() {
        this.lowerLimit = this.clock.currentTimeMillis() - this.timeToKeepInMillis;
    }

    @Override
    public boolean reached(File file, long version, LogFileInformation source) {
        try {
            long firstStartRecordTimestamp = source.getFirstStartRecordTimestamp(version);
            return firstStartRecordTimestamp >= 0L && firstStartRecordTimestamp < this.lowerLimit;
        }
        catch (IllegalLogFormatException e) {
            return LogPruneStrategyFactory.decidePruneForIllegalLogFormat(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

