/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Arrays;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RecordIdIterator;
import org.neo4j.unsafe.impl.batchimport.staging.ReadRecordsStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ReadRelationshipCountsDataStep
extends ReadRecordsStep<RelationshipRecord> {
    private long id = -1L;
    private final long highestId = this.highId - 1L;

    public ReadRelationshipCountsDataStep(StageControl control, Configuration config, RelationshipStore store) {
        super(control, config, store, RecordIdIterator.allIn(store, config));
    }

    protected long[] nextBatchOrNull(long ticket, int batchSize) {
        if (this.id >= this.highestId) {
            return null;
        }
        long[] batch = new long[batchSize * 3];
        int i = 0;
        while (i < batchSize && ++this.id <= this.highestId) {
            if (!this.cursor.next(this.id)) continue;
            int index = i++ * 3;
            batch[index++] = ((RelationshipRecord)this.record).getFirstNode();
            batch[index++] = ((RelationshipRecord)this.record).getType();
            batch[index++] = ((RelationshipRecord)this.record).getSecondNode();
        }
        return i == batchSize ? batch : Arrays.copyOf(batch, i * 3);
    }

    @Override
    protected long position() {
        return this.doneBatches.get() * (long)this.batchSize * (long)this.store.getRecordSize();
    }
}

