/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import org.neo4j.kernel.configuration.Settings;

public class ThresholdConfigParser {
    public static ThresholdConfigValue parse(String configValue) {
        String[] tokens = configValue.split(" ");
        if (tokens.length == 0) {
            throw new IllegalArgumentException("Invalid log pruning configuration value '" + configValue + "'");
        }
        String boolOrNumber = tokens[0];
        if (tokens.length == 1) {
            switch (boolOrNumber) {
                case "true": {
                    return ThresholdConfigValue.NO_PRUNING;
                }
                case "false": {
                    return new ThresholdConfigValue("entries", 1L);
                }
            }
            throw new IllegalArgumentException("Invalid log pruning configuration value '" + configValue + "'. The form is 'all' or '<number><unit> <type>' for example '100k txs' " + "for the latest 100 000 transactions");
        }
        long thresholdValue = Settings.parseLongWithUnit(tokens[0]);
        String thresholdType = tokens[1];
        return new ThresholdConfigValue(thresholdType, thresholdValue);
    }

    public static final class ThresholdConfigValue {
        public static final ThresholdConfigValue NO_PRUNING = new ThresholdConfigValue("false", -1L);
        public final String type;
        public final long value;

        public ThresholdConfigValue(String type, long value) {
            this.type = type;
            this.value = value;
        }
    }
}

