/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.security;

public interface AccessMode {
    public boolean allowsReads();

    public boolean allowsWrites();

    public boolean allowsSchemaWrites();

    public String name();

    public static enum Static implements AccessMode
    {
        NONE{

            @Override
            public boolean allowsReads() {
                return false;
            }

            @Override
            public boolean allowsWrites() {
                return false;
            }

            @Override
            public boolean allowsSchemaWrites() {
                return false;
            }
        }
        ,
        READ{

            @Override
            public boolean allowsReads() {
                return true;
            }

            @Override
            public boolean allowsWrites() {
                return false;
            }

            @Override
            public boolean allowsSchemaWrites() {
                return false;
            }
        }
        ,
        WRITE_ONLY{

            @Override
            public boolean allowsReads() {
                return false;
            }

            @Override
            public boolean allowsWrites() {
                return true;
            }

            @Override
            public boolean allowsSchemaWrites() {
                return false;
            }
        }
        ,
        WRITE{

            @Override
            public boolean allowsReads() {
                return true;
            }

            @Override
            public boolean allowsWrites() {
                return true;
            }

            @Override
            public boolean allowsSchemaWrites() {
                return false;
            }
        }
        ,
        FULL{

            @Override
            public boolean allowsReads() {
                return true;
            }

            @Override
            public boolean allowsWrites() {
                return true;
            }

            @Override
            public boolean allowsSchemaWrites() {
                return true;
            }
        };

    }
}

