/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Set;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;

public class KernelTransactionsSnapshot {
    private Tx relevantTransactions;

    public KernelTransactionsSnapshot(Set<KernelTransactionImplementation> allTransactions) {
        Tx head = null;
        for (KernelTransactionImplementation tx : allTransactions) {
            if (!tx.isOpen()) continue;
            Tx current = new Tx(tx, tx.getReuseCount());
            if (head != null) {
                current.next = head;
                head = current;
                continue;
            }
            head = current;
        }
        this.relevantTransactions = head;
    }

    public boolean allClosed() {
        while (this.relevantTransactions != null) {
            if (!this.relevantTransactions.haveClosed()) {
                return false;
            }
            this.relevantTransactions = this.relevantTransactions.next;
        }
        return true;
    }

    private static class Tx {
        private final KernelTransactionImplementation transaction;
        private final int reuseCount;
        private Tx next;

        Tx(KernelTransactionImplementation tx, int reuseCount) {
            this.transaction = tx;
            this.reuseCount = reuseCount;
        }

        boolean haveClosed() {
            return this.transaction.getReuseCount() != this.reuseCount;
        }
    }
}

