/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputNodeCacher;
import org.neo4j.unsafe.impl.batchimport.input.InputNodeReader;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationshipCacher;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationshipReader;
import org.neo4j.unsafe.impl.batchimport.input.Receiver;

public class InputCache
implements Closeable {
    public static final String MAIN = "main";
    private static final String HEADER = "-header";
    private static final String NODES = "nodes";
    private static final String RELATIONSHIPS = "relationships";
    private static final String NODES_HEADER = "nodes-header";
    private static final String RELATIONSHIPS_HEADER = "relationships-header";
    static final byte SAME_GROUP = 0;
    static final byte NEW_GROUP = 1;
    static final byte PROPERTY_KEY_TOKEN = 0;
    static final byte LABEL_TOKEN = 1;
    static final byte RELATIONSHIP_TYPE_TOKEN = 2;
    static final byte GROUP_TOKEN = 3;
    static final byte HIGH_TOKEN_TYPE = 4;
    static final short HAS_FIRST_PROPERTY_ID = -1;
    static final byte HAS_LABEL_FIELD = 3;
    static final byte LABEL_REMOVAL = 1;
    static final byte LABEL_ADDITION = 2;
    static final byte END_OF_LABEL_CHANGES = 0;
    static final byte HAS_TYPE_ID = 2;
    static final byte SAME_TYPE = 0;
    static final byte NEW_TYPE = 1;
    static final byte END_OF_HEADER = -2;
    static final short END_OF_ENTITIES = -3;
    private final FileSystemAbstraction fs;
    private final File cacheDirectory;
    private RecordFormats recordFormats;
    private final int bufferSize;
    private final Set<String> subTypes = new HashSet<String>();

    public InputCache(FileSystemAbstraction fs, File cacheDirectory, RecordFormats recordFormats) {
        this(fs, cacheDirectory, recordFormats, (int)ByteUnit.kibiBytes((long)512L));
    }

    public InputCache(FileSystemAbstraction fs, File cacheDirectory, RecordFormats recordFormats, int bufferSize) {
        this.fs = fs;
        this.cacheDirectory = cacheDirectory;
        this.recordFormats = recordFormats;
        this.bufferSize = bufferSize;
    }

    public Receiver<InputNode[], IOException> cacheNodes(String subType) throws IOException {
        return new InputNodeCacher(this.channel(NODES, subType, "rw"), this.channel(NODES_HEADER, subType, "rw"), this.recordFormats, this.bufferSize);
    }

    public Receiver<InputRelationship[], IOException> cacheRelationships(String subType) throws IOException {
        return new InputRelationshipCacher(this.channel(RELATIONSHIPS, subType, "rw"), this.channel(RELATIONSHIPS_HEADER, subType, "rw"), this.recordFormats, this.bufferSize);
    }

    private StoreChannel channel(String type, String subType, String mode) throws IOException {
        return this.fs.open(this.file(type, subType), mode);
    }

    private File file(String type, String subType) {
        this.subTypes.add(subType);
        return new File(this.cacheDirectory, "input-" + type + "-" + subType);
    }

    public InputIterable<InputNode> nodes(final String subType, final boolean deleteAfterUse) {
        return this.entities(new ThrowingSupplier<InputIterator<InputNode>, IOException>(){

            public InputIterator<InputNode> get() throws IOException {
                return new InputNodeReader(InputCache.this.channel(InputCache.NODES, subType, "r"), InputCache.this.channel(InputCache.NODES_HEADER, subType, "r"), InputCache.this.bufferSize, InputCache.this.deleteAction(deleteAfterUse, InputCache.NODES, InputCache.NODES_HEADER, subType));
            }
        });
    }

    public InputIterable<InputRelationship> relationships(final String subType, final boolean deleteAfterUse) {
        return this.entities(new ThrowingSupplier<InputIterator<InputRelationship>, IOException>(){

            public InputIterator<InputRelationship> get() throws IOException {
                return new InputRelationshipReader(InputCache.this.channel(InputCache.RELATIONSHIPS, subType, "r"), InputCache.this.channel(InputCache.RELATIONSHIPS_HEADER, subType, "r"), InputCache.this.bufferSize, InputCache.this.deleteAction(deleteAfterUse, InputCache.RELATIONSHIPS, InputCache.RELATIONSHIPS_HEADER, subType));
            }
        });
    }

    protected Runnable deleteAction(boolean deleteAfterUse, String type, String header, String subType) {
        if (!deleteAfterUse) {
            return () -> {};
        }
        return () -> {
            this.fs.deleteFile(this.file(type, subType));
            this.fs.deleteFile(this.file(header, subType));
            this.subTypes.remove(subType);
        };
    }

    private <T extends InputEntity> InputIterable<T> entities(final ThrowingSupplier<InputIterator<T>, IOException> factory) {
        return new InputIterable<T>(){

            @Override
            public InputIterator<T> iterator() {
                try {
                    return (InputIterator)factory.get();
                }
                catch (IOException e) {
                    throw new InputException("Unable to read cached relationship", e);
                }
            }

            @Override
            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }

    @Override
    public void close() throws IOException {
        for (String subType : this.subTypes) {
            this.fs.deleteFile(this.file(NODES, subType));
            this.fs.deleteFile(this.file(RELATIONSHIPS, subType));
            this.fs.deleteFile(this.file(NODES_HEADER, subType));
            this.fs.deleteFile(this.file(RELATIONSHIPS_HEADER, subType));
        }
    }
}

