/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.helpers.SocketAddress;

public class SocketAddressFormat {
    private static final Pattern hostnamePortPattern = Pattern.compile("(?<hostname>[^\\s]+):(?<port>\\d+)");
    private static final Pattern portPattern = Pattern.compile(":(?<port>\\d+)");

    public static <T extends SocketAddress> T socketAddress(String name, String value, String defaultHostname, int defaultPort, BiFunction<String, Integer, T> constructor) {
        String hostname = defaultHostname;
        int port = defaultPort;
        if (value != null) {
            String trimmedValue = value.trim();
            Matcher hostnamePortMatcher = hostnamePortPattern.matcher(trimmedValue);
            Matcher portMatcher = portPattern.matcher(trimmedValue);
            if (hostnamePortMatcher.matches()) {
                hostname = hostnamePortMatcher.group("hostname");
                port = Integer.parseInt(hostnamePortMatcher.group("port"));
            } else if (portMatcher.matches()) {
                port = Integer.parseInt(portMatcher.group("port"));
            } else {
                throw new IllegalArgumentException(String.format("Setting \"%s\" must be in the format \"hostname:port\" or \":port\". \"%s\" does not conform to these formats", name, value));
            }
        }
        return (T)((SocketAddress)constructor.apply(hostname, port));
    }

    public static <T extends SocketAddress> T socketAddress(String value, BiFunction<String, Integer, T> constructor) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot parse socket address from null");
        }
        String trimmedValue = value.trim();
        Matcher hostnamePortMatcher = hostnamePortPattern.matcher(trimmedValue);
        if (hostnamePortMatcher.matches()) {
            String hostname = hostnamePortMatcher.group("hostname");
            int port = Integer.parseInt(hostnamePortMatcher.group("port"));
            return (T)((SocketAddress)constructor.apply(hostname, port));
        }
        throw new IllegalArgumentException(String.format("Configured socket address must be in the format \"hostname:port\". \"%s\" does not conform to this format", value));
    }
}

