/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.kernel.api.ExecutingQueryStatus;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.LockWaitEvent;
import org.neo4j.kernel.impl.query.QuerySource;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.time.CpuClock;
import org.neo4j.time.SystemNanoClock;

public class ExecutingQuery {
    private static final AtomicLongFieldUpdater<ExecutingQuery> WAIT_TIME = AtomicLongFieldUpdater.newUpdater(ExecutingQuery.class, "waitTimeNanos");
    private final long queryId;
    private final LockTracer lockTracer = this::waitForLock;
    private final String username;
    private final QuerySource querySource;
    private final String queryText;
    private final Map<String, Object> queryParameters;
    private final long startTime;
    private final Thread threadExecutingTheQuery;
    private final SystemNanoClock clock;
    private final CpuClock cpuClock;
    private final long cpuTimeNanosWhenQueryStarted;
    private Map<String, Object> metaData;
    private volatile ExecutingQueryStatus status = ExecutingQueryStatus.RUNNING;
    private volatile long waitTimeNanos;

    public ExecutingQuery(long queryId, QuerySource querySource, String username, String queryText, Map<String, Object> queryParameters, Map<String, Object> metaData, Thread threadExecutingTheQuery, SystemNanoClock clock, CpuClock cpuClock) {
        this.queryId = queryId;
        this.querySource = querySource;
        this.username = username;
        this.queryText = queryText;
        this.queryParameters = queryParameters;
        this.clock = clock;
        this.startTime = clock.millis();
        this.metaData = metaData;
        this.threadExecutingTheQuery = threadExecutingTheQuery;
        this.cpuClock = cpuClock;
        this.cpuTimeNanosWhenQueryStarted = cpuClock.cpuTimeNanos(threadExecutingTheQuery);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutingQuery that = (ExecutingQuery)o;
        return this.queryId == that.queryId;
    }

    public int hashCode() {
        return (int)(this.queryId ^ this.queryId >>> 32);
    }

    public long internalQueryId() {
        return this.queryId;
    }

    public String username() {
        return this.username;
    }

    public QuerySource querySource() {
        return this.querySource;
    }

    public String queryText() {
        return this.queryText;
    }

    public Map<String, Object> queryParameters() {
        return this.queryParameters;
    }

    public long startTime() {
        return this.startTime;
    }

    public long elapsedTimeMillis() {
        return this.clock.millis() - this.startTime;
    }

    public long cpuTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.cpuClock.cpuTimeNanos(this.threadExecutingTheQuery) - this.cpuTimeNanosWhenQueryStarted);
    }

    public long waitTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.waitTimeNanos + this.status.waitTimeNanos(this.clock));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public Map<String, Object> metaData() {
        return this.metaData;
    }

    public LockTracer lockTracer() {
        return this.lockTracer;
    }

    public Map<String, Object> status() {
        return this.status.toMap(this.clock);
    }

    private LockWaitEvent waitForLock(ResourceType resourceType, long[] resourceIds) {
        WaitingOnLockEvent event = new WaitingOnLockEvent(resourceType, resourceIds);
        this.status = event;
        return event;
    }

    private class WaitingOnLockEvent
    extends ExecutingQueryStatus.WaitingOnLock
    implements LockWaitEvent {
        private final ExecutingQueryStatus previous;

        WaitingOnLockEvent(ResourceType resourceType, long[] resourceIds) {
            super(resourceType, resourceIds, ExecutingQuery.this.clock.nanos());
            this.previous = ExecutingQuery.this.status;
        }

        @Override
        public void close() {
            if (ExecutingQuery.this.status != this) {
                return;
            }
            WAIT_TIME.addAndGet(ExecutingQuery.this, this.waitTimeNanos(ExecutingQuery.this.clock));
            ExecutingQuery.this.status = this.previous;
        }
    }
}

