/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.util.Objects;
import org.neo4j.kernel.configuration.Settings;

public class ThresholdConfigParser {
    public static ThresholdConfigValue parse(String configValue) {
        String[] tokens = configValue.split(" ");
        if (tokens.length == 0) {
            throw new IllegalArgumentException("Invalid log pruning configuration value '" + configValue + "'");
        }
        String boolOrNumber = tokens[0];
        if (tokens.length == 1) {
            switch (boolOrNumber) {
                case "keep_all": 
                case "true": {
                    return ThresholdConfigValue.NO_PRUNING;
                }
                case "keep_none": 
                case "false": {
                    return ThresholdConfigValue.KEEP_LAST_FILE;
                }
            }
            throw new IllegalArgumentException("Invalid log pruning configuration value '" + configValue + "'. The form is 'all' or '<number><unit> <type>' for example '100k txs' for the latest 100 000 transactions");
        }
        long thresholdValue = Settings.parseLongWithUnit(boolOrNumber);
        String thresholdType = tokens[1];
        return new ThresholdConfigValue(thresholdType, thresholdValue);
    }

    public static final class ThresholdConfigValue {
        static final ThresholdConfigValue NO_PRUNING = new ThresholdConfigValue("false", -1L);
        static final ThresholdConfigValue KEEP_LAST_FILE = new ThresholdConfigValue("entries", 1L);
        public final String type;
        public final long value;

        ThresholdConfigValue(String type, long value) {
            this.type = type;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThresholdConfigValue that = (ThresholdConfigValue)o;
            return this.value == that.value && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }
    }
}

