/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.DuplicateInputIdException;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class BadCollector
implements Collector {
    public static final int BAD_RELATIONSHIPS = 1;
    public static final int DUPLICATE_NODES = 2;
    public static final int EXTRA_COLUMNS = 4;
    public static final int COLLECT_ALL = 7;
    private final PrintStream out;
    private final int tolerance;
    private final int collect;
    private long[] leftOverDuplicateNodeIds = new long[10];
    private int leftOverDuplicateNodeIdsCursor;
    private final boolean logBadEntries;
    private volatile int badEntries;
    public static final int UNLIMITED_TOLERANCE = -1;

    public BadCollector(OutputStream out, int tolerance, int collect) {
        this(out, tolerance, collect, false);
    }

    public BadCollector(OutputStream out, int tolerance, int collect, boolean skipBadEntriesLogging) {
        this.out = new PrintStream(out);
        this.tolerance = tolerance;
        this.collect = collect;
        this.logBadEntries = !skipBadEntriesLogging;
    }

    @Override
    public void collectBadRelationship(InputRelationship relationship, Object specificValue) {
        this.checkTolerance(1, new RelationshipsProblemReporter(relationship, specificValue));
    }

    @Override
    public void collectDuplicateNode(Object id, long actualId, String group, String firstSource, String otherSource) {
        this.checkTolerance(2, new NodesProblemReporter(id, group, firstSource, otherSource));
        if (this.leftOverDuplicateNodeIdsCursor == this.leftOverDuplicateNodeIds.length) {
            this.leftOverDuplicateNodeIds = Arrays.copyOf(this.leftOverDuplicateNodeIds, this.leftOverDuplicateNodeIds.length * 2);
        }
        this.leftOverDuplicateNodeIds[this.leftOverDuplicateNodeIdsCursor++] = actualId;
    }

    @Override
    public void collectExtraColumns(String source, long row, String value) {
        this.checkTolerance(4, new ExtraColumnsProblemReporter(row, source, value));
    }

    @Override
    public PrimitiveLongIterator leftOverDuplicateNodesIds() {
        this.leftOverDuplicateNodeIds = Arrays.copyOf(this.leftOverDuplicateNodeIds, this.leftOverDuplicateNodeIdsCursor);
        Arrays.sort(this.leftOverDuplicateNodeIds);
        return PrimitiveLongCollections.iterator((long[])this.leftOverDuplicateNodeIds);
    }

    @Override
    public void close() {
        this.out.flush();
    }

    @Override
    public int badEntries() {
        return this.badEntries;
    }

    private boolean collects(int bit) {
        return (this.collect & bit) != 0;
    }

    private void checkTolerance(int bit, ProblemReporter report) {
        boolean collect = this.collects(bit);
        if (collect) {
            if (this.logBadEntries) {
                this.out.println(report.message());
            }
            ++this.badEntries;
        }
        if (!collect || this.tolerance != -1 && this.badEntries > this.tolerance) {
            InputException exception = report.exception();
            throw collect ? (InputException)Exceptions.withMessage((Throwable)exception, (String)String.format("Too many bad entries %d, where last one was: %s", this.badEntries, exception.getMessage())) : exception;
        }
    }

    private static class ExtraColumnsProblemReporter
    implements ProblemReporter {
        private String message;
        private final long row;
        private final String source;
        private final String value;

        ExtraColumnsProblemReporter(long row, String source, String value) {
            this.row = row;
            this.source = source;
            this.value = value;
        }

        @Override
        public String message() {
            return this.getReportMessage();
        }

        @Override
        public InputException exception() {
            return new InputException(this.getReportMessage());
        }

        private String getReportMessage() {
            if (this.message == null) {
                this.message = String.format("Extra column not present in header on line %d in %s with value %s", this.row, this.source, this.value);
            }
            return this.message;
        }
    }

    private static class NodesProblemReporter
    implements ProblemReporter {
        private final Object id;
        private final String group;
        private final String firstSource;
        private final String otherSource;

        NodesProblemReporter(Object id, String group, String firstSource, String otherSource) {
            this.id = id;
            this.group = group;
            this.firstSource = firstSource;
            this.otherSource = otherSource;
        }

        @Override
        public String message() {
            return DuplicateInputIdException.message(this.id, this.group, this.firstSource, this.otherSource);
        }

        @Override
        public InputException exception() {
            return new DuplicateInputIdException(this.id, this.group, this.firstSource, this.otherSource);
        }
    }

    private static class RelationshipsProblemReporter
    implements ProblemReporter {
        private String message;
        private final InputRelationship relationship;
        private final Object specificValue;

        RelationshipsProblemReporter(InputRelationship relationship, Object specificValue) {
            this.relationship = relationship;
            this.specificValue = specificValue;
        }

        @Override
        public String message() {
            return this.getReportMessage();
        }

        @Override
        public InputException exception() {
            return new InputException(this.getReportMessage());
        }

        private String getReportMessage() {
            if (this.message == null) {
                this.message = String.format("%s referring to missing node %s", this.relationship, this.specificValue);
            }
            return this.message;
        }
    }

    private static interface ProblemReporter {
        public String message();

        public InputException exception();
    }
}

