/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.time.Clocks;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.DynamicProcessorAssigner;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisor;
import org.neo4j.unsafe.impl.batchimport.staging.MultiExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;

public class ExecutionSupervisors {
    public static void superviseDynamicExecution(Stage stage) {
        ExecutionSupervisors.superviseDynamicExecution(ExecutionMonitors.invisible(), stage);
    }

    public static void superviseDynamicExecution(ExecutionMonitor monitor, Stage stage) {
        ExecutionSupervisors.superviseDynamicExecution(monitor, Configuration.DEFAULT, stage);
    }

    public static void superviseDynamicExecution(ExecutionMonitor monitor, Configuration config, Stage stage) {
        ExecutionSupervisors.superviseExecution(ExecutionSupervisors.withDynamicProcessorAssignment(monitor, config), config, stage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void superviseExecution(ExecutionMonitor monitor, Configuration config, Stage stage) {
        ExecutionSupervisor supervisor = new ExecutionSupervisor(Clocks.systemClock(), monitor);
        StageExecution execution = null;
        try {
            execution = stage.execute();
            supervisor.supervise(execution);
        }
        finally {
            stage.close();
            if (execution != null) {
                execution.assertHealthy();
            }
        }
    }

    public static ExecutionMonitor withDynamicProcessorAssignment(ExecutionMonitor monitor, Configuration config) {
        DynamicProcessorAssigner dynamicProcessorAssigner = new DynamicProcessorAssigner(config, Math.min(config.maxNumberOfProcessors(), Runtime.getRuntime().availableProcessors()));
        return new MultiExecutionMonitor(monitor, dynamicProcessorAssigner);
    }
}

