/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Predicate;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.IoProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public abstract class IteratorBatcherStep<T>
extends IoProducerStep {
    private final Iterator<T> data;
    private final Class<T> itemClass;
    private final Predicate<T> filter;
    protected long cursor;
    private T[] batch;
    private int batchCursor;
    private int skipped;

    public IteratorBatcherStep(StageControl control, Configuration config, Iterator<T> data, Class<T> itemClass, Predicate<T> filter) {
        super(control, config);
        this.data = data;
        this.itemClass = itemClass;
        this.filter = filter;
        this.newBatch();
    }

    private void newBatch() {
        this.batchCursor = 0;
        this.batch = (Object[])Array.newInstance(this.itemClass, this.batchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object nextBatchOrNull(long ticket, int batchSize) {
        while (this.data.hasNext()) {
            T candidate = this.data.next();
            if (this.filter.test(candidate)) {
                this.batch[this.batchCursor++] = candidate;
                ++this.cursor;
                if (this.batchCursor != batchSize) continue;
                T[] result = this.batch;
                this.newBatch();
                return result;
            }
            if (++this.skipped != batchSize) continue;
            this.skipped = 0;
            return Array.newInstance(this.itemClass, 0);
        }
        if (this.batchCursor == 0) {
            return null;
        }
        try {
            T[] TArray = this.batchCursor == batchSize ? this.batch : Arrays.copyOf(this.batch, this.batchCursor);
            return TArray;
        }
        finally {
            this.batchCursor = 0;
        }
    }
}

