/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityReader;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class InputRelationshipReader
extends InputEntityReader<InputRelationship> {
    public InputRelationshipReader(StoreChannel channel, StoreChannel header, int bufferSize, Runnable closeAction, int maxNbrOfProcessors) throws IOException {
        super(channel, header, bufferSize, closeAction, maxNbrOfProcessors);
    }

    @Override
    protected InputRelationship readNextOrNull(Object properties, InputEntityReader.ProcessorState state) throws IOException {
        Object type;
        ReadableClosablePositionAwareChannel channel = state.batchChannel;
        Group startNodeGroup = this.readGroup(0, state);
        Group endNodeGroup = this.readGroup(1, state);
        Object startNodeId = this.readValue(channel);
        Object endNodeId = this.readValue(channel);
        byte typeMode = channel.get();
        switch (typeMode) {
            case 0: {
                type = state.previousType;
                break;
            }
            case 1: {
                state.previousType = (String)this.readToken((byte)2, channel);
                type = state.previousType;
                break;
            }
            case 2: {
                type = channel.getInt();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized type mode " + typeMode);
            }
        }
        return new InputRelationship(this.sourceDescription(), this.lineNumber(), this.position(), properties.getClass().isArray() ? (Object[])properties : InputEntity.NO_PROPERTIES, properties.getClass().isArray() ? null : (Long)properties, startNodeGroup, startNodeId, endNodeGroup, endNodeId, type instanceof String ? (String)type : null, type instanceof String ? null : (Integer)type);
    }
}

