/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query.clientconnection;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;

public class BoltConnectionInfo
extends ClientConnectionInfo {
    private final String principalName;
    private final String clientName;
    private final SocketAddress clientAddress;
    private final SocketAddress serverAddress;

    public BoltConnectionInfo(String principalName, String clientName, SocketAddress clientAddress, SocketAddress serverAddress) {
        this.principalName = principalName;
        this.clientName = clientName;
        this.clientAddress = clientAddress;
        this.serverAddress = serverAddress;
    }

    @Override
    public String asConnectionDetails() {
        return String.format("bolt-session\tbolt\t%s\t%s\t\tclient%s\tserver%s>", this.principalName, this.clientName, this.clientAddress, this.serverAddress);
    }

    @Override
    public String protocol() {
        return "bolt";
    }

    @Override
    public String clientAddress() {
        return this.addressString(this.clientAddress);
    }

    @Override
    public String requestURI() {
        return this.addressString(this.serverAddress);
    }

    private String addressString(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)address;
            return String.format("%s:%s", inet.getHostString(), inet.getPort());
        }
        return address.toString();
    }
}

