/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreFileType;

public enum StoreFile {
    NODE_STORE(".nodestore.db"),
    NODE_LABEL_STORE(".nodestore.db.labels"),
    PROPERTY_STORE(".propertystore.db"),
    PROPERTY_ARRAY_STORE(".propertystore.db.arrays"),
    PROPERTY_STRING_STORE(".propertystore.db.strings"),
    PROPERTY_KEY_TOKEN_STORE(".propertystore.db.index"),
    PROPERTY_KEY_TOKEN_NAMES_STORE(".propertystore.db.index.keys"),
    RELATIONSHIP_STORE(".relationshipstore.db"),
    RELATIONSHIP_GROUP_STORE(".relationshipgroupstore.db"),
    RELATIONSHIP_TYPE_TOKEN_STORE(".relationshiptypestore.db"),
    RELATIONSHIP_TYPE_TOKEN_NAMES_STORE(".relationshiptypestore.db.names"),
    LABEL_TOKEN_STORE(".labeltokenstore.db"),
    LABEL_TOKEN_NAMES_STORE(".labeltokenstore.db.names"),
    SCHEMA_STORE(".schemastore.db"),
    COUNTS_STORE_LEFT(".counts.db.a", false){

        @Override
        public boolean isOptional() {
            return true;
        }
    }
    ,
    COUNTS_STORE_RIGHT(".counts.db.b", false){

        @Override
        public boolean isOptional() {
            return true;
        }
    }
    ,
    NEO_STORE("");

    private final String storeFileNamePart;
    private final boolean recordStore;

    private StoreFile(String storeFileNamePart) {
        this(storeFileNamePart, true);
    }

    private StoreFile(String storeFileNamePart, boolean recordStore) {
        this.storeFileNamePart = storeFileNamePart;
        this.recordStore = recordStore;
    }

    public String fileName(StoreFileType type) {
        return type.augment("neostore" + this.storeFileNamePart);
    }

    public String storeFileName() {
        return this.fileName(StoreFileType.STORE);
    }

    public String fileNamePart() {
        return this.storeFileNamePart;
    }

    public boolean isRecordStore() {
        return this.recordStore;
    }

    public static Iterable<StoreFile> currentStoreFiles() {
        return Iterables.iterable((Object[])StoreFile.values());
    }

    public static void fileOperation(FileOperation operation, FileSystemAbstraction fs, File fromDirectory, File toDirectory, Iterable<StoreFile> files, boolean allowSkipNonExistentFiles, ExistingTargetStrategy existingTargetStrategy, StoreFileType ... types) throws IOException {
        for (StoreFile storeFile : files) {
            for (StoreFileType type : types) {
                String fileName = storeFile.fileName(type);
                operation.perform(fs, fileName, fromDirectory, allowSkipNonExistentFiles, toDirectory, existingTargetStrategy);
            }
        }
    }

    public boolean isOptional() {
        return false;
    }
}

