/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.transaction.log.LogTailScanner;

public class UpgradableDatabase {
    private final StoreVersionCheck storeVersionCheck;
    private final RecordFormats format;
    private final LogTailScanner tailScanner;

    public UpgradableDatabase(StoreVersionCheck storeVersionCheck, RecordFormats format, LogTailScanner tailScanner) {
        this.storeVersionCheck = storeVersionCheck;
        this.format = format;
        this.tailScanner = tailScanner;
    }

    public RecordFormats checkUpgradeable(File storeDirectory) {
        StoreVersionCheck.Result result = this.storeVersionCheck.hasVersion(new File(storeDirectory, "neostore"), this.format.storeVersion());
        if (result.outcome.isSuccessful()) {
            return this.format;
        }
        try {
            RecordFormats fromFormat = RecordFormatSelector.selectForVersion(result.actualVersion);
            if (FormatFamily.isLowerFamilyFormat(this.format, fromFormat)) {
                throw new StoreUpgrader.UnexpectedUpgradingStoreFormatException();
            }
            if (FormatFamily.isSameFamily(fromFormat, this.format) && fromFormat.generation() > this.format.generation()) {
                result = new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.attemptedStoreDowngrade, fromFormat.storeVersion(), new File(storeDirectory, "neostore").getAbsolutePath());
            } else {
                result = this.checkCleanShutDownByCheckPoint();
                if (result.outcome.isSuccessful()) {
                    return fromFormat;
                }
            }
        }
        catch (IllegalArgumentException e) {
            result = new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.unexpectedStoreVersion, result.actualVersion, result.storeFilename);
        }
        switch (result.outcome) {
            case missingStoreFile: {
                throw new StoreUpgrader.UpgradeMissingStoreFilesException(this.getPathToStoreFile(storeDirectory, result));
            }
            case storeVersionNotFound: {
                throw new StoreUpgrader.UpgradingStoreVersionNotFoundException(this.getPathToStoreFile(storeDirectory, result));
            }
            case attemptedStoreDowngrade: {
                throw new StoreUpgrader.AttemptedDowngradeException();
            }
            case unexpectedStoreVersion: {
                throw new StoreUpgrader.UnexpectedUpgradingStoreVersionException(result.actualVersion, this.format.storeVersion());
            }
            case storeNotCleanlyShutDown: {
                throw new StoreUpgrader.DatabaseNotCleanlyShutDownException();
            }
        }
        throw new IllegalArgumentException("Unexpected outcome: " + result.outcome.name());
    }

    private StoreVersionCheck.Result checkCleanShutDownByCheckPoint() {
        try {
            if (!this.tailScanner.getTailInformation().commitsAfterLastCheckPoint) {
                return new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.ok, null, null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new StoreVersionCheck.Result(StoreVersionCheck.Result.Outcome.storeNotCleanlyShutDown, null, null);
    }

    private String getPathToStoreFile(File storeDirectory, StoreVersionCheck.Result result) {
        return new File(storeDirectory, result.storeFilename).getAbsolutePath();
    }

    boolean hasCurrentVersion(File storeDir) {
        File neoStore = new File(storeDir, "neostore");
        StoreVersionCheck.Result result = this.storeVersionCheck.hasVersion(neoStore, this.format.storeVersion());
        switch (result.outcome) {
            case missingStoreFile: 
            case ok: {
                return true;
            }
            case storeVersionNotFound: 
            case attemptedStoreDowngrade: 
            case unexpectedStoreVersion: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown outcome: " + result.outcome.name());
    }

    public String currentVersion() {
        return this.format.storeVersion();
    }
}

