/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.stream.Stream;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;

public class InputEntityDecorators {
    public static final Decorator<InputNode> NO_NODE_DECORATOR = value -> value;
    public static final Decorator<InputRelationship> NO_RELATIONSHIP_DECORATOR = value -> value;

    private InputEntityDecorators() {
    }

    public static Decorator<InputNode> additiveLabels(String[] labelNamesToAdd) {
        if (labelNamesToAdd == null || labelNamesToAdd.length == 0) {
            return NO_NODE_DECORATOR;
        }
        return node -> {
            if (node.hasLabelField()) {
                return node;
            }
            String[] union = ArrayUtil.union(node.labels(), labelNamesToAdd);
            if (union != node.labels()) {
                node.setLabels(union);
            }
            return node;
        };
    }

    public static Decorator<InputRelationship> defaultRelationshipType(String defaultType) {
        if (defaultType == null) {
            return value -> value;
        }
        return relationship -> {
            if (relationship.type() == null && !relationship.hasTypeId()) {
                relationship.setType(defaultType);
            }
            return relationship;
        };
    }

    public static <ENTITY extends InputEntity> Decorator<ENTITY> decorators(final Decorator<ENTITY> ... decorators) {
        return new Decorator<ENTITY>(){

            @Override
            public ENTITY apply(ENTITY from) {
                for (Decorator decorator : decorators) {
                    from = (InputEntity)decorator.apply(from);
                }
                return from;
            }

            @Override
            public boolean isMutable() {
                return Stream.of(decorators).anyMatch(Decorator::isMutable);
            }
        };
    }

    public static <ENTITY extends InputEntity> Decorator<ENTITY> noDecorator() {
        return value -> value;
    }
}

