/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import org.neo4j.csv.reader.SourceTraceability;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputEntityDeserialization;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class InputRelationshipDeserialization
extends InputEntityDeserialization<InputRelationship> {
    private final Header header;
    private final Groups groups;
    private Group startNodeGroup;
    private Group endNodeGroup;
    private String type;
    private Object startNode;
    private Object endNode;

    public InputRelationshipDeserialization(Header header, SourceTraceability source, Groups groups) {
        super(source);
        this.header = header;
        this.groups = groups;
    }

    @Override
    public void initialize() {
        this.startNodeGroup = this.groups.getOrCreate(this.header.entry(Type.START_ID).groupName());
        this.endNodeGroup = this.groups.getOrCreate(this.header.entry(Type.END_ID).groupName());
    }

    @Override
    public void handle(Header.Entry entry, Object value) {
        switch (entry.type()) {
            case TYPE: {
                this.type = (String)value;
                break;
            }
            case START_ID: {
                this.startNode = value;
                break;
            }
            case END_ID: {
                this.endNode = value;
                break;
            }
            default: {
                super.handle(entry, value);
            }
        }
    }

    @Override
    public InputRelationship materialize() {
        return new InputRelationship(this.source.sourceDescription(), this.source.lineNumber(), this.source.position(), this.properties(), null, this.startNodeGroup, this.startNode, this.endNodeGroup, this.endNode, this.type, null);
    }

    @Override
    public void clear() {
        super.clear();
        this.type = null;
        this.endNode = null;
        this.startNode = null;
    }
}

