/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.concurrent.CountDownLatch;
import org.neo4j.function.FailableConsumer;
import org.neo4j.function.ThrowingSupplier;

public class FailableConcurrentTransfer<TYPE>
implements FailableConsumer<TYPE>,
ThrowingSupplier<TYPE, Exception> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private TYPE value;
    private Exception failure;

    public void accept(TYPE value) {
        this.value = value;
        this.latch.countDown();
    }

    public void fail(Exception failure) {
        this.failure = failure;
        this.latch.countDown();
    }

    public TYPE get() throws Exception {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Thread interrupted", e);
        }
        if (this.failure != null) {
            throw this.failure;
        }
        return this.value;
    }

    public String toString() {
        return String.format("ConcurrentTransfer{%s}", this.latch.getCount() == 1L ? "<waiting>" : this.value);
    }
}

