/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public abstract class Service {
    private static final boolean printServiceLoaderStackTraces = FeatureToggles.flag(Service.class, (String)"printServiceLoaderStackTraces", (boolean)false);
    final Set<String> keys;

    public static <T> Iterable<T> load(Class<T> type) {
        Iterable<T> loader = Service.java6Loader(type);
        if (null != loader) {
            return loader;
        }
        return Collections.emptyList();
    }

    public static <T extends Service> T loadSilently(Class<T> type, String key) {
        for (Service service : Service.load(type)) {
            if (!service.matches(key)) continue;
            return (T)service;
        }
        return null;
    }

    public static <T extends Service> T load(Class<T> type, String key) {
        T service = Service.loadSilently(type, key);
        if (service == null) {
            throw new NoSuchElementException(String.format("Could not find any implementation of %s with a key=\"%s\"", type.getName(), key));
        }
        return service;
    }

    protected Service(String key, String ... altKeys) {
        if (altKeys == null || altKeys.length == 0) {
            this.keys = Collections.singleton(key);
        } else {
            this.keys = new HashSet<String>(Arrays.asList(altKeys));
            this.keys.add(key);
        }
    }

    public String toString() {
        return this.getClass().getSuperclass().getName() + "" + this.keys;
    }

    public boolean matches(String key) {
        return this.keys.contains(key);
    }

    public Iterable<String> getKeys() {
        return this.keys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service service = (Service)o;
        return this.keys.equals(service.keys);
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    private static <T> Iterable<T> filterExceptions(final Iterable<T> iterable) {
        return () -> new PrefetchingIterator<T>(){
            final Iterator iterator;
            {
                this.iterator = iterable.iterator();
            }

            protected T fetchNextOrNull() {
                while (this.iterator.hasNext()) {
                    try {
                        return this.iterator.next();
                    }
                    catch (Throwable e) {
                        if (!printServiceLoaderStackTraces) continue;
                        e.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    private static <T> Iterable<T> java6Loader(Class<T> type) {
        try {
            HashMap services = new HashMap();
            ClassLoader currentCL = Service.class.getClassLoader();
            ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
            ServiceLoader<T> contextClassLoaderServices = ServiceLoader.load(type, contextCL);
            if (currentCL != contextCL) {
                ServiceLoader<T> currentClassLoaderServices = ServiceLoader.load(type, currentCL);
                Service.putAllInstancesToMap(currentClassLoaderServices, services);
            }
            Service.putAllInstancesToMap(contextClassLoaderServices, services);
            return services.values();
        }
        catch (Exception | LinkageError e) {
            if (printServiceLoaderStackTraces) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static <T> void putAllInstancesToMap(Iterable<T> services, Map<String, T> servicesMap) {
        for (T instance : Service.filterExceptions(services)) {
            if (null == instance) continue;
            servicesMap.put(instance.getClass().getName(), instance);
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Implementation {
        public Class<?>[] value();
    }
}

