/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import java.util.function.Predicate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public abstract class IndexQuery
implements Predicate<Value> {
    private final int propertyKeyId;

    public static ExistsPredicate exists(int propertyKeyId) {
        return new ExistsPredicate(propertyKeyId);
    }

    public static ExactPredicate exact(int propertyKeyId, Object value) {
        return new ExactPredicate(propertyKeyId, value);
    }

    public static NumberRangePredicate range(int propertyKeyId, Number from, boolean fromInclusive, Number to, boolean toInclusive) {
        return new NumberRangePredicate(propertyKeyId, from, fromInclusive, to, toInclusive);
    }

    public static StringRangePredicate range(int propertyKeyId, String from, boolean fromInclusive, String to, boolean toInclusive) {
        return new StringRangePredicate(propertyKeyId, from, fromInclusive, to, toInclusive);
    }

    public static StringPrefixPredicate stringPrefix(int propertyKeyId, String prefix) {
        return new StringPrefixPredicate(propertyKeyId, prefix);
    }

    public static StringContainsPredicate stringContains(int propertyKeyId, String contains) {
        return new StringContainsPredicate(propertyKeyId, contains);
    }

    public static StringSuffixPredicate stringSuffix(int propertyKeyId, String suffix) {
        return new StringSuffixPredicate(propertyKeyId, suffix);
    }

    public static ValueTuple asValueTuple(ExactPredicate ... query) {
        Value[] values = new Value[query.length];
        for (int i = 0; i < query.length; ++i) {
            values[i] = query[i].value();
        }
        return ValueTuple.of((Value[])values);
    }

    protected IndexQuery(int propertyKeyId) {
        this.propertyKeyId = propertyKeyId;
    }

    public abstract IndexQueryType type();

    public final boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    public final int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public final int propertyKeyId() {
        return this.propertyKeyId;
    }

    @Override
    public abstract boolean test(Value var1);

    public static final class StringSuffixPredicate
    extends IndexQuery {
        private final String suffix;

        StringSuffixPredicate(int propertyKeyId, String suffix) {
            super(propertyKeyId);
            this.suffix = suffix;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.stringSuffix;
        }

        @Override
        public boolean test(Value value) {
            return value != null && Values.isTextValue((Object)value) && ((String)value.asObject()).endsWith(this.suffix);
        }

        public String suffix() {
            return this.suffix;
        }
    }

    public static final class StringContainsPredicate
    extends IndexQuery {
        private final String contains;

        StringContainsPredicate(int propertyKeyId, String contains) {
            super(propertyKeyId);
            this.contains = contains;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.stringContains;
        }

        @Override
        public boolean test(Value value) {
            return value != null && Values.isTextValue((Object)value) && ((String)value.asObject()).contains(this.contains);
        }

        public String contains() {
            return this.contains;
        }
    }

    public static final class StringPrefixPredicate
    extends IndexQuery {
        private final String prefix;

        StringPrefixPredicate(int propertyKeyId, String prefix) {
            super(propertyKeyId);
            this.prefix = prefix;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.stringPrefix;
        }

        @Override
        public boolean test(Value value) {
            return value != null && Values.isTextValue((Object)value) && ((TextValue)value).stringValue().startsWith(this.prefix);
        }

        public String prefix() {
            return this.prefix;
        }
    }

    public static final class StringRangePredicate
    extends IndexQuery {
        private final Value from;
        private final boolean fromInclusive;
        private final Value to;
        private final boolean toInclusive;

        StringRangePredicate(int propertyKeyId, String from, boolean fromInclusive, String to, boolean toInclusive) {
            super(propertyKeyId);
            this.from = Values.stringOrNoValue((String)from);
            this.fromInclusive = fromInclusive;
            this.to = Values.stringOrNoValue((String)to);
            this.toInclusive = toInclusive;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.rangeString;
        }

        @Override
        public boolean test(Value value) {
            int compare;
            if (value == null) {
                return false;
            }
            if (!Values.isTextValue((Object)value)) {
                return false;
            }
            if (this.from != Values.NO_VALUE && ((compare = Values.COMPARATOR.compare(value, this.from)) < 0 || !this.fromInclusive && compare == 0)) {
                return false;
            }
            return this.to == Values.NO_VALUE || (compare = Values.COMPARATOR.compare(value, this.to)) <= 0 && (this.toInclusive || compare != 0);
        }

        public String from() {
            return (String)this.from.asObject();
        }

        public boolean fromInclusive() {
            return this.fromInclusive;
        }

        public String to() {
            return (String)this.to.asObject();
        }

        public boolean toInclusive() {
            return this.toInclusive;
        }
    }

    public static final class NumberRangePredicate
    extends IndexQuery {
        private final Value from;
        private final boolean fromInclusive;
        private final Value to;
        private final boolean toInclusive;

        NumberRangePredicate(int propertyKeyId, Number from, boolean fromInclusive, Number to, boolean toInclusive) {
            super(propertyKeyId);
            this.from = Values.numberValue((Number)from);
            this.fromInclusive = fromInclusive;
            this.to = Values.numberValue((Number)to);
            this.toInclusive = toInclusive;
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.rangeNumeric;
        }

        @Override
        public boolean test(Value value) {
            if (value == null) {
                return false;
            }
            if (Values.isNumberValue((Object)value)) {
                int compare;
                if (this.from != Values.NO_VALUE && ((compare = Values.COMPARATOR.compare(value, this.from)) < 0 || !this.fromInclusive && compare == 0)) {
                    return false;
                }
                return this.to == Values.NO_VALUE || (compare = Values.COMPARATOR.compare(value, this.to)) <= 0 && (this.toInclusive || compare != 0);
            }
            return false;
        }

        public Number from() {
            return (Number)this.from.asObject();
        }

        public Number to() {
            return (Number)this.to.asObject();
        }

        public Value fromAsValue() {
            return this.from;
        }

        public Value toAsValue() {
            return this.to;
        }

        public boolean fromInclusive() {
            return this.fromInclusive;
        }

        public boolean toInclusive() {
            return this.toInclusive;
        }
    }

    public static final class ExactPredicate
    extends IndexQuery {
        private final Value exactValue;

        ExactPredicate(int propertyKeyId, Object value) {
            super(propertyKeyId);
            this.exactValue = value instanceof Value ? (Value)value : Values.of((Object)value);
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.exact;
        }

        @Override
        public boolean test(Value value) {
            return this.exactValue.equals(value);
        }

        public Value value() {
            return this.exactValue;
        }
    }

    public static final class ExistsPredicate
    extends IndexQuery {
        ExistsPredicate(int propertyKeyId) {
            super(propertyKeyId);
        }

        @Override
        public IndexQueryType type() {
            return IndexQueryType.exists;
        }

        @Override
        public boolean test(Value value) {
            return value != null && value != Values.NO_VALUE;
        }
    }

    public static enum IndexQueryType {
        exists,
        exact,
        rangeString,
        rangeNumeric,
        stringPrefix,
        stringSuffix,
        stringContains;

    }
}

