/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.storageengine.api.PropertyItem;

class PropertyContainerProxyHelper {
    private PropertyContainerProxyHelper() {
    }

    static Map<String, Object> getProperties(Statement statement, Cursor<PropertyItem> propertyCursor, String[] keys) {
        int numberOfKeys = keys.length;
        HashMap<String, Object> properties = new HashMap<String, Object>((int)((float)numberOfKeys * 1.3f));
        int[] propertyKeys = PropertyContainerProxyHelper.getPropertyKeys(statement, keys, numberOfKeys);
        int propertiesToFind = numberOfKeys;
        block0: while (propertiesToFind > 0 && propertyCursor.next()) {
            PropertyItem propertyItem = (PropertyItem)propertyCursor.get();
            int propertyKeyId = propertyItem.propertyKeyId();
            for (int i = 0; i < propertyKeys.length; ++i) {
                if (propertyKeys[i] != propertyKeyId) continue;
                properties.put(keys[i], propertyItem.value().asObjectCopy());
                --propertiesToFind;
                continue block0;
            }
        }
        return properties;
    }

    private static int[] getPropertyKeys(Statement statement, String[] keys, int numberOfKeys) {
        int[] propertyKeys = new int[numberOfKeys];
        ReadOperations readOperations = statement.readOperations();
        for (int i = 0; i < numberOfKeys; ++i) {
            String key = keys[i];
            if (key == null) {
                throw new NullPointerException(String.format("Key %d was null", i + 1));
            }
            propertyKeys[i] = readOperations.propertyKeyGetForName(key);
        }
        return propertyKeys;
    }
}

