/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.Arrays;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.LockWaitEvent;
import org.neo4j.storageengine.api.lock.ResourceType;

final class CombinedTracer
implements LockTracer {
    private final LockTracer[] tracers;

    CombinedTracer(LockTracer ... tracers) {
        this.tracers = tracers;
    }

    @Override
    public LockWaitEvent waitForLock(boolean exclusive, ResourceType resourceType, long ... resourceIds) {
        LockWaitEvent[] events = new LockWaitEvent[this.tracers.length];
        for (int i = 0; i < events.length; ++i) {
            events[i] = this.tracers[i].waitForLock(exclusive, resourceType, resourceIds);
        }
        return new CombinedEvent(events);
    }

    @Override
    public LockTracer combine(LockTracer tracer) {
        LockTracer[] tracers;
        if (tracer == NONE) {
            return this;
        }
        if (tracer instanceof CombinedTracer) {
            LockTracer[] those = ((CombinedTracer)tracer).tracers;
            tracers = Arrays.copyOf(this.tracers, this.tracers.length + those.length);
            System.arraycopy(those, 0, tracers, this.tracers.length, those.length);
        } else {
            tracers = Arrays.copyOf(this.tracers, this.tracers.length + 1);
            tracers[this.tracers.length] = tracer;
        }
        return new CombinedTracer(tracers);
    }

    private static class CombinedEvent
    implements LockWaitEvent {
        private final LockWaitEvent[] events;

        CombinedEvent(LockWaitEvent[] events) {
            this.events = events;
        }

        @Override
        public void close() {
            for (LockWaitEvent event : this.events) {
                event.close();
            }
        }
    }
}

