/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.net.URL;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.coreapi.CoreAPIAvailabilityGuard;
import org.neo4j.kernel.impl.factory.DataSourceModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.proc.ProcedureGDBFacadeSPI;

public class ProcedureGDSFactory
implements ThrowingFunction<Context, GraphDatabaseService, ProcedureException> {
    private final PlatformModule platform;
    private final DataSourceModule dataSource;
    private final DependencyResolver resolver;
    private final CoreAPIAvailabilityGuard availability;
    private final ThrowingFunction<URL, URL, URLAccessValidationError> urlValidator;

    public ProcedureGDSFactory(PlatformModule platform, DataSourceModule dataSource, DependencyResolver resolver, CoreAPIAvailabilityGuard coreAPIAvailabilityGuard) {
        this.platform = platform;
        this.dataSource = dataSource;
        this.resolver = resolver;
        this.availability = coreAPIAvailabilityGuard;
        this.urlValidator = url -> platform.urlAccessRule.validate((Configuration)platform.config, url);
    }

    public GraphDatabaseService apply(Context context) throws ProcedureException {
        KernelTransaction tx = context.getOrElse(Context.KERNEL_TRANSACTION, null);
        SecurityContext securityContext = tx != null ? tx.securityContext() : context.get(Context.SECURITY_CONTEXT);
        GraphDatabaseFacade facade = new GraphDatabaseFacade();
        facade.init(new ProcedureGDBFacadeSPI(this.platform, this.dataSource, this.resolver, this.availability, this.urlValidator, securityContext), this.dataSource.guard, this.dataSource.threadToTransactionBridge, this.platform.config);
        return facade;
    }
}

