/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.TokenFactory;

public abstract class TokenStore<RECORD extends TokenRecord, TOKEN extends Token>
extends CommonAbstractStore<RECORD, NoStoreHeader> {
    public static final int NAME_STORE_BLOCK_SIZE = 30;
    private final DynamicStringStore nameStore;
    private final TokenFactory<TOKEN> tokenFactory;

    public TokenStore(File file, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, DynamicStringStore nameStore, String typeDescriptor, TokenFactory<TOKEN> tokenFactory, RecordFormat<RECORD> recordFormat, String storeVersion, OpenOption ... openOptions) {
        super(file, configuration, idType, idGeneratorFactory, pageCache, logProvider, typeDescriptor, recordFormat, NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, storeVersion, openOptions);
        this.nameStore = nameStore;
        this.tokenFactory = tokenFactory;
    }

    public DynamicStringStore getNameStore() {
        return this.nameStore;
    }

    @Override
    protected boolean isOnlyFastIdGeneratorRebuildEnabled(Config config) {
        return false;
    }

    public List<TOKEN> getTokens(int maxCount) {
        LinkedList<TOKEN> records = new LinkedList<TOKEN>();
        long maxIdInUse = this.getHighestPossibleIdInUse();
        int found = 0;
        TokenRecord record = (TokenRecord)this.newRecord();
        int i = 0;
        while ((long)i <= maxIdInUse && found < maxCount) {
            if (this.getRecord(i, record, RecordLoad.CHECK).inUse()) {
                ++found;
                if (record != null && record.inUse() && record.getNameId() != Record.RESERVED.intValue()) {
                    records.add(this.tokenFactory.newToken(this.getStringFor(record), i));
                }
            }
            ++i;
        }
        return records;
    }

    public TOKEN getToken(int id) {
        TokenRecord record = (TokenRecord)this.getRecord(id, this.newRecord(), RecordLoad.NORMAL);
        return this.tokenFactory.newToken(this.getStringFor(record), record.getIntId());
    }

    public Collection<DynamicRecord> allocateNameRecords(byte[] chars) {
        ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>();
        this.nameStore.allocateRecordsFromBytes(records, chars);
        return records;
    }

    @Override
    public void updateRecord(RECORD record) {
        super.updateRecord(record);
        if (!((TokenRecord)record).isLight()) {
            for (DynamicRecord keyRecord : ((TokenRecord)record).getNameRecords()) {
                this.nameStore.updateRecord(keyRecord);
            }
        }
    }

    @Override
    public void ensureHeavy(RECORD record) {
        if (!((TokenRecord)record).isLight()) {
            return;
        }
        ((TokenRecord)record).addNameRecords(this.nameStore.getRecords(((TokenRecord)record).getNameId(), RecordLoad.NORMAL));
    }

    public String getStringFor(RECORD nameRecord) {
        this.ensureHeavy(nameRecord);
        int recordToFind = ((TokenRecord)nameRecord).getNameId();
        Iterator<DynamicRecord> records = ((TokenRecord)nameRecord).getNameRecords().iterator();
        ArrayList<DynamicRecord> relevantRecords = new ArrayList<DynamicRecord>();
        while (recordToFind != Record.NO_NEXT_BLOCK.intValue() && records.hasNext()) {
            DynamicRecord record = records.next();
            if (!record.inUse() || record.getId() != (long)recordToFind) continue;
            recordToFind = (int)record.getNextBlock();
            relevantRecords.add(record);
            records = ((TokenRecord)nameRecord).getNameRecords().iterator();
        }
        return PropertyStore.decodeString((byte[])this.nameStore.readFullByteArray(relevantRecords, PropertyType.STRING).other());
    }
}

