/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphdb.Resource;

public final class DiffApplyingPrimitiveIntIterator
extends PrimitiveIntCollections.PrimitiveIntBaseIterator
implements Resource {
    private final PrimitiveIntIterator source;
    private final Iterator<?> addedElementsIterator;
    private final Set<?> addedElements;
    private final Set<?> removedElements;
    private Phase phase;

    public DiffApplyingPrimitiveIntIterator(PrimitiveIntIterator source, Set<?> addedElements, Set<?> removedElements) {
        this.source = source;
        this.addedElements = addedElements;
        this.addedElementsIterator = addedElements.iterator();
        this.removedElements = removedElements;
        this.phase = Phase.FILTERED_SOURCE;
    }

    protected boolean fetchNext() {
        return this.phase.fetchNext(this);
    }

    private boolean computeNextFromSourceAndFilter() {
        while (this.source.hasNext()) {
            int value = this.source.next();
            if (this.removedElements.contains(value) || this.addedElements.contains(value)) continue;
            return this.next(value);
        }
        this.transitionToAddedElements();
        return this.phase.fetchNext(this);
    }

    private void transitionToAddedElements() {
        this.phase = !this.addedElementsIterator.hasNext() ? Phase.NO_ADDED_ELEMENTS : Phase.ADDED_ELEMENTS;
    }

    private boolean computeNextFromAddedElements() {
        return this.addedElementsIterator.hasNext() && this.next((Integer)this.addedElementsIterator.next());
    }

    public void close() {
        if (this.source instanceof Resource) {
            ((Resource)this.source).close();
        }
    }

    private static enum Phase {
        FILTERED_SOURCE{

            @Override
            boolean fetchNext(DiffApplyingPrimitiveIntIterator self) {
                return self.computeNextFromSourceAndFilter();
            }
        }
        ,
        ADDED_ELEMENTS{

            @Override
            boolean fetchNext(DiffApplyingPrimitiveIntIterator self) {
                return self.computeNextFromAddedElements();
            }
        }
        ,
        NO_ADDED_ELEMENTS{

            @Override
            boolean fetchNext(DiffApplyingPrimitiveIntIterator self) {
                return false;
            }
        };


        abstract boolean fetchNext(DiffApplyingPrimitiveIntIterator var1);
    }
}

