/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.BaseNumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public abstract class OffHeapNumberArray<N extends NumberArray<N>>
extends BaseNumberArray<N> {
    private final long allocatedAddress;
    protected final long address;
    protected final long length;
    private boolean closed;

    protected OffHeapNumberArray(long length, int itemSize, long base) {
        super(itemSize, base);
        boolean itemSizeIsPowerOfTwo;
        UnsafeUtil.assertHasUnsafe();
        this.length = length;
        long dataSize = length * (long)itemSize;
        boolean bl = itemSizeIsPowerOfTwo = Integer.bitCount(itemSize) == 1;
        if (UnsafeUtil.allowUnalignedMemoryAccess || !itemSizeIsPowerOfTwo) {
            this.allocatedAddress = this.address = UnsafeUtil.allocateMemory((long)dataSize);
        } else {
            this.allocatedAddress = UnsafeUtil.allocateMemory((long)(dataSize + (long)itemSize - 1L));
            this.address = UnsafeUtil.alignedMemory((long)this.allocatedAddress, (int)itemSize);
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.offHeapUsage(this.length * (long)this.itemSize);
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.length > 0L) {
                UnsafeUtil.free((long)this.allocatedAddress);
            }
            this.closed = true;
        }
    }
}

