/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.neo4j.io.ByteUnit;

public class Format {
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("UTC");
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSZ";
    public static final String TIME_FORMAT = "HH:mm:ss.SSS";
    private static final String[] BYTE_SIZES = new String[]{"B", "kB", "MB", "GB"};
    private static final ThreadLocalFormat DATE = new ThreadLocalFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
    private static final ThreadLocalFormat TIME = new ThreadLocalFormat("HH:mm:ss.SSS");
    private static int KB = (int)ByteUnit.kibiBytes((long)1L);

    public static String date() {
        return Format.date(DEFAULT_TIME_ZONE);
    }

    public static String date(TimeZone timeZone) {
        return Format.date(new Date(), timeZone);
    }

    public static String date(long millis) {
        return Format.date(millis, DEFAULT_TIME_ZONE);
    }

    public static String date(long millis, TimeZone timeZone) {
        return Format.date(new Date(millis), timeZone);
    }

    public static String date(Date date) {
        return Format.date(date, DEFAULT_TIME_ZONE);
    }

    public static String date(Date date, TimeZone timeZone) {
        return DATE.format(date, timeZone);
    }

    public static String time() {
        return Format.time(DEFAULT_TIME_ZONE);
    }

    public static String time(TimeZone timeZone) {
        return Format.time(new Date());
    }

    public static String time(long millis) {
        return Format.time(millis, DEFAULT_TIME_ZONE);
    }

    public static String time(long millis, TimeZone timeZone) {
        return Format.time(new Date(millis), timeZone);
    }

    public static String time(Date date) {
        return Format.time(date, DEFAULT_TIME_ZONE);
    }

    public static String time(Date date, TimeZone timeZone) {
        return TIME.format(date, timeZone);
    }

    public static String bytes(long bytes) {
        double size = bytes;
        for (String suffix : BYTE_SIZES) {
            if (size < (double)KB) {
                return String.format(Locale.ROOT, "%.2f %s", size, suffix);
            }
            size /= (double)KB;
        }
        return String.format(Locale.ROOT, "%.2f TB", size);
    }

    public static String duration(long durationMillis) {
        return Format.duration(durationMillis, TimeUnit.DAYS, TimeUnit.MILLISECONDS);
    }

    public static String duration(long durationMillis, TimeUnit highestGranularity, TimeUnit lowestGranularity) {
        StringBuilder builder = new StringBuilder();
        TimeUnit[] units = TimeUnit.values();
        Format.reverse(units);
        boolean use = false;
        for (TimeUnit unit : units) {
            if (unit.equals((Object)highestGranularity)) {
                use = true;
            }
            if (!use) continue;
            durationMillis = Format.extractFromDuration(durationMillis, unit, builder);
            if (unit.equals((Object)lowestGranularity)) break;
        }
        return builder.toString();
    }

    private static <T> void reverse(T[] array) {
        int half = array.length >> 1;
        for (int i = 0; i < half; ++i) {
            T temp = array[i];
            int highIndex = array.length - 1 - i;
            array[i] = array[highIndex];
            array[highIndex] = temp;
        }
    }

    private static String shortName(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
        }
        return unit.name().substring(0, 1).toLowerCase();
    }

    private static long extractFromDuration(long durationMillis, TimeUnit unit, StringBuilder target) {
        int count = 0;
        long millisPerUnit = unit.toMillis(1L);
        while (durationMillis >= millisPerUnit) {
            ++count;
            durationMillis -= millisPerUnit;
        }
        if (count > 0) {
            target.append(target.length() > 0 ? " " : "").append(count).append(Format.shortName(unit));
        }
        return durationMillis;
    }

    private Format() {
    }

    private static class ThreadLocalFormat
    extends ThreadLocal<DateFormat> {
        private final String format;

        ThreadLocalFormat(String format) {
            this.format = format;
        }

        String format(Date date, TimeZone timeZone) {
            DateFormat dateFormat = (DateFormat)this.get();
            dateFormat.setTimeZone(timeZone);
            return dateFormat.format(date);
        }

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(this.format);
        }
    }
}

