/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.Optional;
import javax.annotation.Nullable;
import org.neo4j.helpers.HostnamePort;

public class OptionalHostnamePort {
    private Optional<String> hostname;
    private Optional<Integer> port;
    private Optional<Integer> upperRangePort;

    public OptionalHostnamePort(Optional<String> hostname, Optional<Integer> port, Optional<Integer> upperRangePort) {
        this.hostname = hostname;
        this.port = port;
        this.upperRangePort = upperRangePort;
    }

    public OptionalHostnamePort(@Nullable String hostname, @Nullable Integer port, @Nullable Integer upperRangePort) {
        this.hostname = Optional.ofNullable(hostname);
        this.port = Optional.ofNullable(port);
        this.upperRangePort = Optional.ofNullable(upperRangePort);
    }

    public Optional<String> getHostname() {
        return this.hostname;
    }

    public Optional<Integer> getPort() {
        return this.port;
    }

    public HostnamePort resolve() {
        if (!this.hostname.isPresent()) {
            throw new IllegalStateException("Hostname must be established before resolving");
        }
        if (!this.port.isPresent()) {
            throw new IllegalStateException("Port must be established before resolving");
        }
        return this.upperRangePort.map(upperRange -> new HostnamePort(this.hostname.get(), this.port.get(), (int)upperRange)).orElse(new HostnamePort(this.hostname.get(), this.port.get()));
    }

    public String toString() {
        return String.format("OptionalHostnamePort<%s,%s,%s>", this.hostname, this.port, this.upperRangePort);
    }
}

