/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Stream;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntObjectVisitor;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectVisitor;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.locking.LockClientStateHolder;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.community.LockManagerImpl;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.LockTransaction;
import org.neo4j.kernel.impl.locking.community.RWLock;
import org.neo4j.storageengine.api.lock.ResourceType;

public class CommunityLockClient
implements Locks.Client {
    private final LockManagerImpl manager;
    private final LockTransaction lockTransaction = new LockTransaction();
    private final PrimitiveIntObjectMap<PrimitiveLongObjectMap<LockResource>> sharedLocks = Primitive.intObjectMap();
    private final PrimitiveIntObjectMap<PrimitiveLongObjectMap<LockResource>> exclusiveLocks = Primitive.intObjectMap();
    private final PrimitiveLongObjectVisitor<LockResource, RuntimeException> readReleaser;
    private final PrimitiveLongObjectVisitor<LockResource, RuntimeException> writeReleaser;
    private final PrimitiveIntObjectVisitor<PrimitiveLongObjectMap<LockResource>, RuntimeException> typeReadReleaser;
    private final PrimitiveIntObjectVisitor<PrimitiveLongObjectMap<LockResource>, RuntimeException> typeWriteReleaser;
    private final LockClientStateHolder stateHolder = new LockClientStateHolder();

    public CommunityLockClient(LockManagerImpl manager) {
        this.manager = manager;
        this.readReleaser = (key, lockResource) -> {
            manager.releaseReadLock(lockResource, this.lockTransaction);
            return false;
        };
        this.writeReleaser = (key, lockResource) -> {
            manager.releaseWriteLock(lockResource, this.lockTransaction);
            return false;
        };
        this.typeReadReleaser = (key, value) -> {
            value.visitEntries(this.readReleaser);
            return false;
        };
        this.typeWriteReleaser = (key, value) -> {
            value.visitEntries(this.writeReleaser);
            return false;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients(this);
        try {
            PrimitiveLongObjectMap<LockResource> localLocks = this.localShared(resourceType);
            for (long resourceId : resourceIds) {
                LockResource resource = (LockResource)localLocks.get(resourceId);
                if (resource != null) {
                    resource.acquireReference();
                    continue;
                }
                resource = new LockResource(resourceType, resourceId);
                if (this.manager.getReadLock(tracer, resource, this.lockTransaction)) {
                    localLocks.put(resourceId, (Object)resource);
                    continue;
                }
                throw new LockClientStoppedException(this);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients(this);
        try {
            PrimitiveLongObjectMap<LockResource> localLocks = this.localExclusive(resourceType);
            for (long resourceId : resourceIds) {
                LockResource resource = (LockResource)localLocks.get(resourceId);
                if (resource != null) {
                    resource.acquireReference();
                    continue;
                }
                resource = new LockResource(resourceType, resourceId);
                if (this.manager.getWriteLock(tracer, resource, this.lockTransaction)) {
                    localLocks.put(resourceId, (Object)resource);
                    continue;
                }
                throw new LockClientStoppedException(this);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
        this.stateHolder.incrementActiveClients(this);
        try {
            PrimitiveLongObjectMap<LockResource> localLocks = this.localExclusive(resourceType);
            LockResource resource = (LockResource)localLocks.get(resourceId);
            if (resource != null) {
                resource.acquireReference();
                boolean bl = true;
                return bl;
            }
            resource = new LockResource(resourceType, resourceId);
            if (this.manager.tryWriteLock(resource, this.lockTransaction)) {
                localLocks.put(resourceId, (Object)resource);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trySharedLock(ResourceType resourceType, long resourceId) {
        this.stateHolder.incrementActiveClients(this);
        try {
            PrimitiveLongObjectMap<LockResource> localLocks = this.localShared(resourceType);
            LockResource resource = (LockResource)localLocks.get(resourceId);
            if (resource != null) {
                resource.acquireReference();
                boolean bl = true;
                return bl;
            }
            resource = new LockResource(resourceType, resourceId);
            if (this.manager.tryReadLock(resource, this.lockTransaction)) {
                localLocks.put(resourceId, (Object)resource);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reEnterShared(ResourceType resourceType, long resourceId) {
        this.stateHolder.incrementActiveClients(this);
        try {
            boolean bl = this.reEnter(this.localShared(resourceType), resourceId);
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reEnterExclusive(ResourceType resourceType, long resourceId) {
        this.stateHolder.incrementActiveClients(this);
        try {
            boolean bl = this.reEnter(this.localExclusive(resourceType), resourceId);
            return bl;
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    private boolean reEnter(PrimitiveLongObjectMap<LockResource> localLocks, long resourceId) {
        LockResource resource = (LockResource)localLocks.get(resourceId);
        if (resource != null) {
            resource.acquireReference();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseShared(ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients(this);
        try {
            PrimitiveLongObjectMap<LockResource> localLocks = this.localShared(resourceType);
            for (long resourceId : resourceIds) {
                LockResource resource = (LockResource)localLocks.get(resourceId);
                if (resource.releaseReference() != 0) continue;
                localLocks.remove(resourceId);
                this.manager.releaseReadLock(new LockResource(resourceType, resourceId), this.lockTransaction);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
        this.stateHolder.incrementActiveClients(this);
        try {
            PrimitiveLongObjectMap<LockResource> localLocks = this.localExclusive(resourceType);
            for (long resourceId : resourceIds) {
                LockResource resource = (LockResource)localLocks.get(resourceId);
                if (resource.releaseReference() != 0) continue;
                localLocks.remove(resourceId);
                this.manager.releaseWriteLock(new LockResource(resourceType, resourceId), this.lockTransaction);
            }
        }
        finally {
            this.stateHolder.decrementActiveClients();
        }
    }

    @Override
    public void prepare() {
        this.stateHolder.prepare(this);
    }

    @Override
    public void stop() {
        if (this.stateHolder.stopClient()) {
            this.terminateAllWaitersAndWaitForClientsToLeave();
            this.releaseLocks();
        }
    }

    private void terminateAllWaitersAndWaitForClientsToLeave() {
        this.terminateAllWaiters();
        while (this.stateHolder.hasActiveClients()) {
            this.terminateAllWaiters();
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(20L));
        }
    }

    @Override
    public void close() {
        this.stateHolder.closeClient();
        this.terminateAllWaitersAndWaitForClientsToLeave();
        this.releaseLocks();
    }

    private void releaseLocks() {
        this.exclusiveLocks.visitEntries(this.typeWriteReleaser);
        this.sharedLocks.visitEntries(this.typeReadReleaser);
        this.exclusiveLocks.clear();
        this.sharedLocks.clear();
    }

    private void terminateAllWaiters() {
        this.manager.accept((Visitor<RWLock, RuntimeException>)((Visitor)lock -> {
            lock.terminateLockRequestsForLockTransaction(this.lockTransaction);
            return false;
        }));
    }

    @Override
    public int getLockSessionId() {
        return this.lockTransaction.getId();
    }

    @Override
    public Stream<? extends ActiveLock> activeLocks() {
        ArrayList<ActiveLock> locks = new ArrayList<ActiveLock>();
        this.exclusiveLocks.visitEntries(CommunityLockClient.collectActiveLocks(locks, ActiveLock.Factory.EXCLUSIVE_LOCK));
        this.sharedLocks.visitEntries(CommunityLockClient.collectActiveLocks(locks, ActiveLock.Factory.SHARED_LOCK));
        return locks.stream();
    }

    @Override
    public long activeLockCount() {
        LockCounter counter = new LockCounter();
        this.exclusiveLocks.visitEntries((PrimitiveIntObjectVisitor)counter);
        this.sharedLocks.visitEntries((PrimitiveIntObjectVisitor)counter);
        return counter.locks;
    }

    private static PrimitiveIntObjectVisitor<PrimitiveLongObjectMap<LockResource>, RuntimeException> collectActiveLocks(List<ActiveLock> locks, ActiveLock.Factory activeLock) {
        return (typeId, exclusive) -> {
            ResourceType resourceType = ResourceTypes.fromId(typeId);
            exclusive.visitEntries((resourceId, lock) -> {
                locks.add(activeLock.create(resourceType, resourceId));
                return false;
            });
            return false;
        };
    }

    private PrimitiveLongObjectMap<LockResource> localShared(ResourceType resourceType) {
        PrimitiveLongObjectMap map = (PrimitiveLongObjectMap)this.sharedLocks.get(resourceType.typeId());
        if (map == null) {
            map = Primitive.longObjectMap();
            this.sharedLocks.put(resourceType.typeId(), (Object)map);
        }
        return map;
    }

    private PrimitiveLongObjectMap<LockResource> localExclusive(ResourceType resourceType) {
        PrimitiveLongObjectMap map = (PrimitiveLongObjectMap)this.exclusiveLocks.get(resourceType.typeId());
        if (map == null) {
            map = Primitive.longObjectMap();
            this.exclusiveLocks.put(resourceType.typeId(), (Object)map);
        }
        return map;
    }

    public String toString() {
        return String.format("%s[%d]", this.getClass().getSimpleName(), this.getLockSessionId());
    }

    private static class LockCounter
    implements PrimitiveIntObjectVisitor<PrimitiveLongObjectMap<LockResource>, RuntimeException> {
        long locks;

        private LockCounter() {
        }

        public boolean visited(int key, PrimitiveLongObjectMap<LockResource> value) {
            this.locks += (long)value.size();
            return false;
        }
    }
}

