/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.ExplicitIndexRead;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.ExplicitIndex;
import org.neo4j.kernel.api.ExplicitIndexHits;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.newapi.Cursors;
import org.neo4j.kernel.impl.newapi.ExplicitIndexProgressor;
import org.neo4j.kernel.impl.newapi.NodeCursor;
import org.neo4j.kernel.impl.newapi.NodeExplicitIndexCursor;
import org.neo4j.kernel.impl.newapi.NodeLabelIndexCursor;
import org.neo4j.kernel.impl.newapi.NodeLabelIndexProgressor;
import org.neo4j.kernel.impl.newapi.NodeValueClientFilter;
import org.neo4j.kernel.impl.newapi.NodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.PropertyCursor;
import org.neo4j.kernel.impl.newapi.References;
import org.neo4j.kernel.impl.newapi.RelationshipExplicitIndexCursor;
import org.neo4j.kernel.impl.newapi.RelationshipGroupCursor;
import org.neo4j.kernel.impl.newapi.RelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.RelationshipTraversalCursor;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

abstract class Read
implements TxStateHolder,
org.neo4j.internal.kernel.api.Read,
ExplicitIndexRead,
SchemaRead {
    private final Cursors cursors;
    private final TxStateHolder txStateHolder;
    private final AssertOpen assertOpen;

    Read(Cursors cursors, TxStateHolder txStateHolder, AssertOpen assertOpen) {
        this.cursors = cursors;
        this.txStateHolder = txStateHolder;
        this.assertOpen = assertOpen;
    }

    public final void nodeIndexSeek(IndexReference index, org.neo4j.internal.kernel.api.NodeValueIndexCursor cursor, IndexOrder indexOrder, IndexQuery ... query) throws KernelException {
        ((NodeValueIndexCursor)cursor).setRead(this);
        IndexProgressor.NodeValueClient target = (NodeValueIndexCursor)cursor;
        IndexReader reader = this.indexReader(index);
        if (!reader.hasFullNumberPrecision(query)) {
            IndexQuery[] filters = new IndexQuery[query.length];
            int j = 0;
            block4: for (IndexQuery q : query) {
                switch (q.type()) {
                    case rangeNumeric: {
                        if (reader.hasFullNumberPrecision(q)) continue block4;
                        filters[j++] = q;
                        continue block4;
                    }
                    case exact: {
                        Value value = ((IndexQuery.ExactPredicate)q).value();
                        if (value.valueGroup() != ValueGroup.NUMBER || reader.hasFullNumberPrecision(q)) continue block4;
                        filters[j++] = q;
                        continue block4;
                    }
                }
            }
            if (j > 0) {
                filters = Arrays.copyOf(filters, j);
                target = new NodeValueClientFilter(target, this.cursors.allocateNodeCursor(), this.cursors.allocatePropertyCursor(), this, filters);
            }
        }
        reader.query(target, indexOrder, query);
    }

    public final void nodeIndexScan(IndexReference index, org.neo4j.internal.kernel.api.NodeValueIndexCursor cursor, IndexOrder indexOrder) throws KernelException {
        int firstProperty = index.properties()[0];
        ((NodeValueIndexCursor)cursor).setRead(this);
        this.indexReader(index).query((NodeValueIndexCursor)cursor, indexOrder, new IndexQuery[]{IndexQuery.exists((int)firstProperty)});
    }

    public final void nodeLabelScan(int label, org.neo4j.internal.kernel.api.NodeLabelIndexCursor cursor) {
        ((NodeLabelIndexCursor)cursor).setRead(this);
        this.labelScan((NodeLabelIndexCursor)cursor, this.labelScanReader().nodesWithLabel(label));
    }

    public void nodeLabelUnionScan(org.neo4j.internal.kernel.api.NodeLabelIndexCursor cursor, int ... labels) {
        ((NodeLabelIndexCursor)cursor).setRead(this);
        this.labelScan((NodeLabelIndexCursor)cursor, this.labelScanReader().nodesWithAnyOfLabels(labels));
    }

    public void nodeLabelIntersectionScan(org.neo4j.internal.kernel.api.NodeLabelIndexCursor cursor, int ... labels) {
        ((NodeLabelIndexCursor)cursor).setRead(this);
        this.labelScan((NodeLabelIndexCursor)cursor, this.labelScanReader().nodesWithAllLabels(labels));
    }

    private void labelScan(IndexProgressor.NodeLabelClient client, PrimitiveLongResourceIterator iterator) {
        client.initialize(new NodeLabelIndexProgressor(iterator, client), false);
    }

    public final Scan<org.neo4j.internal.kernel.api.NodeLabelIndexCursor> nodeLabelScan(int label) {
        throw new UnsupportedOperationException("not implemented");
    }

    public final void allNodesScan(org.neo4j.internal.kernel.api.NodeCursor cursor) {
        ((NodeCursor)cursor).scan(this);
    }

    public final Scan<org.neo4j.internal.kernel.api.NodeCursor> allNodesScan() {
        throw new UnsupportedOperationException("not implemented");
    }

    public final void singleNode(long reference, org.neo4j.internal.kernel.api.NodeCursor cursor) {
        ((NodeCursor)cursor).single(reference, this);
    }

    public final void singleRelationship(long reference, org.neo4j.internal.kernel.api.RelationshipScanCursor cursor) {
        ((RelationshipScanCursor)cursor).single(reference, this);
    }

    public final void allRelationshipsScan(org.neo4j.internal.kernel.api.RelationshipScanCursor cursor) {
        ((RelationshipScanCursor)cursor).scan(-1, this);
    }

    public final Scan<org.neo4j.internal.kernel.api.RelationshipScanCursor> allRelationshipsScan() {
        throw new UnsupportedOperationException("not implemented");
    }

    public final void relationshipLabelScan(int label, org.neo4j.internal.kernel.api.RelationshipScanCursor cursor) {
        ((RelationshipScanCursor)cursor).scan(label, this);
    }

    public final Scan<org.neo4j.internal.kernel.api.RelationshipScanCursor> relationshipLabelScan(int label) {
        throw new UnsupportedOperationException("not implemented");
    }

    public final void relationshipGroups(long nodeReference, long reference, org.neo4j.internal.kernel.api.RelationshipGroupCursor cursor) {
        if (reference == -1L) {
            cursor.close();
        } else if (References.hasDirectFlag(reference)) {
            ((RelationshipGroupCursor)cursor).buffer(nodeReference, References.clearFlags(reference), this);
        } else {
            ((RelationshipGroupCursor)cursor).direct(nodeReference, reference, this);
        }
    }

    public final void relationships(long nodeReference, long reference, org.neo4j.internal.kernel.api.RelationshipTraversalCursor cursor) {
        if (reference == -1L) {
            cursor.close();
        } else if (References.hasGroupFlag(reference)) {
            ((RelationshipTraversalCursor)cursor).groups(nodeReference, References.clearFlags(reference), this);
        } else if (References.hasFilterFlag(reference)) {
            ((RelationshipTraversalCursor)cursor).filtered(nodeReference, References.clearFlags(reference), this);
        } else {
            ((RelationshipTraversalCursor)cursor).chain(nodeReference, reference, this);
        }
    }

    public final void nodeProperties(long reference, org.neo4j.internal.kernel.api.PropertyCursor cursor) {
        ((PropertyCursor)cursor).init(reference, this, this.assertOpen);
    }

    public final void relationshipProperties(long reference, org.neo4j.internal.kernel.api.PropertyCursor cursor) {
        ((PropertyCursor)cursor).init(reference, this, this.assertOpen);
    }

    public final void graphProperties(org.neo4j.internal.kernel.api.PropertyCursor cursor) {
        ((PropertyCursor)cursor).init(this.graphPropertiesReference(), this, this.assertOpen);
    }

    abstract long graphPropertiesReference();

    public final void nodeExplicitIndexLookup(org.neo4j.internal.kernel.api.NodeExplicitIndexCursor cursor, String index, String key, Value value) throws KernelException {
        ((NodeExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((NodeExplicitIndexCursor)cursor, this.explicitNodeIndex(index).get(key, value.asObject()));
    }

    public final void nodeExplicitIndexQuery(org.neo4j.internal.kernel.api.NodeExplicitIndexCursor cursor, String index, Object query) throws KernelException {
        ((NodeExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((NodeExplicitIndexCursor)cursor, this.explicitNodeIndex(index).query(query instanceof Value ? ((Value)query).asObject() : query));
    }

    public final void nodeExplicitIndexQuery(org.neo4j.internal.kernel.api.NodeExplicitIndexCursor cursor, String index, String key, Object query) throws KernelException {
        ((NodeExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((NodeExplicitIndexCursor)cursor, this.explicitNodeIndex(index).query(key, query instanceof Value ? ((Value)query).asObject() : query));
    }

    public void relationshipExplicitIndexGet(org.neo4j.internal.kernel.api.RelationshipExplicitIndexCursor cursor, String index, String key, Value value, long source, long target) throws KernelException {
        ((RelationshipExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((RelationshipExplicitIndexCursor)cursor, this.explicitRelationshipIndex(index).get(key, value.asObject(), source, target));
    }

    public void relationshipExplicitIndexQuery(org.neo4j.internal.kernel.api.RelationshipExplicitIndexCursor cursor, String index, Object query, long source, long target) throws KernelException {
        ((RelationshipExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((RelationshipExplicitIndexCursor)cursor, this.explicitRelationshipIndex(index).query(query instanceof Value ? ((Value)query).asObject() : query, source, target));
    }

    public void relationshipExplicitIndexQuery(org.neo4j.internal.kernel.api.RelationshipExplicitIndexCursor cursor, String index, String key, Object query, long source, long target) throws KernelException {
        ((RelationshipExplicitIndexCursor)cursor).setRead(this);
        Read.explicitIndex((RelationshipExplicitIndexCursor)cursor, this.explicitRelationshipIndex(index).query(key, query instanceof Value ? ((Value)query).asObject() : query, source, target));
    }

    private static void explicitIndex(IndexProgressor.ExplicitClient client, ExplicitIndexHits hits) {
        client.initialize(new ExplicitIndexProgressor(hits, client), hits.size());
    }

    public final void futureNodeReferenceRead(long reference) {
    }

    public final void futureRelationshipsReferenceRead(long reference) {
    }

    public final void futureNodePropertyReferenceRead(long reference) {
    }

    public final void futureRelationshipPropertyReferenceRead(long reference) {
    }

    abstract IndexReader indexReader(IndexReference var1);

    abstract LabelScanReader labelScanReader();

    abstract ExplicitIndex explicitNodeIndex(String var1) throws KernelException;

    abstract ExplicitIndex explicitRelationshipIndex(String var1) throws KernelException;

    public abstract CapableIndexReference index(int var1, int ... var2);

    abstract PageCursor nodePage(long var1);

    abstract PageCursor relationshipPage(long var1);

    abstract PageCursor groupPage(long var1);

    abstract PageCursor propertyPage(long var1);

    abstract PageCursor stringPage(long var1);

    abstract PageCursor arrayPage(long var1);

    abstract RecordCursor<DynamicRecord> labelCursor();

    abstract void node(NodeRecord var1, long var2, PageCursor var4);

    abstract void relationship(RelationshipRecord var1, long var2, PageCursor var4);

    abstract void property(PropertyRecord var1, long var2, PageCursor var4);

    abstract void group(RelationshipGroupRecord var1, long var2, PageCursor var4);

    abstract long nodeHighMark();

    abstract long relationshipHighMark();

    abstract TextValue string(PropertyCursor var1, long var2, PageCursor var4);

    abstract ArrayValue array(PropertyCursor var1, long var2, PageCursor var4);

    @Override
    public TransactionState txState() {
        return this.txStateHolder.txState();
    }

    @Override
    public ExplicitIndexTransactionState explicitIndexTxState() {
        return this.txStateHolder.explicitIndexTxState();
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txStateHolder.hasTxStateWithChanges();
    }
}

