/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.schema.IndexProgressor;

class RelationshipExplicitIndexCursor
extends IndexCursor
implements org.neo4j.internal.kernel.api.RelationshipExplicitIndexCursor,
IndexProgressor.ExplicitClient {
    private Read read;
    private int expectedSize;
    private long relationship;
    private float score;

    RelationshipExplicitIndexCursor() {
    }

    @Override
    public void initialize(IndexProgressor progressor, int expectedSize) {
        super.initialize(progressor);
        this.expectedSize = expectedSize;
    }

    @Override
    public boolean acceptEntity(long reference, float score) {
        this.relationship = reference;
        this.score = score;
        return true;
    }

    public void setRead(Read read) {
        this.read = read;
    }

    public int expectedTotalNumberOfResults() {
        return this.expectedSize;
    }

    public float score() {
        return this.score;
    }

    public void relationship(RelationshipScanCursor cursor) {
        this.read.singleRelationship(this.relationship, cursor);
    }

    public void sourceNode(NodeCursor cursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void targetNode(NodeCursor cursor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public int relationshipLabel() {
        throw new UnsupportedOperationException("not implemented");
    }

    public long sourceNodeReference() {
        throw new UnsupportedOperationException("not implemented");
    }

    public long targetNodeReference() {
        throw new UnsupportedOperationException("not implemented");
    }

    public long relationshipReference() {
        return this.relationship;
    }

    @Override
    public void close() {
        super.close();
        this.relationship = -1L;
        this.score = 0.0f;
        this.expectedSize = 0;
        this.read = null;
    }

    @Override
    public boolean isClosed() {
        return super.isClosed();
    }
}

