/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.RelationshipCursor;
import org.neo4j.kernel.impl.newapi.RelationshipGroupCursor;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class RelationshipTraversalCursor
extends RelationshipCursor
implements org.neo4j.internal.kernel.api.RelationshipTraversalCursor {
    private long originNodeReference;
    private long next;
    private Record buffer;
    private PageCursor pageCursor;
    private final RelationshipGroupCursor group;
    private GroupState groupState;
    private FilterState filterState;
    private int filterType = -1;

    RelationshipTraversalCursor(RelationshipGroupCursor group) {
        this.group = group;
    }

    void buffered(long nodeReference, Record record, Read read) {
        this.originNodeReference = nodeReference;
        this.buffer = Record.initialize(record);
        this.groupState = GroupState.NONE;
        this.filterState = FilterState.NONE;
        this.filterType = -1;
        this.read = read;
    }

    void chain(long nodeReference, long reference, Read read) {
        if (this.pageCursor == null) {
            this.pageCursor = read.relationshipPage(reference);
        }
        this.setId(-1L);
        this.groupState = GroupState.NONE;
        this.filterState = FilterState.NONE;
        this.filterType = -1;
        this.originNodeReference = nodeReference;
        this.next = reference;
        this.read = read;
    }

    void groups(long nodeReference, long groupReference, Read read) {
        this.setId(-1L);
        this.next = -1L;
        this.groupState = GroupState.INCOMING;
        this.filterState = FilterState.NONE;
        this.filterType = -1;
        this.originNodeReference = nodeReference;
        read.relationshipGroups(nodeReference, groupReference, this.group);
        this.read = read;
    }

    void filtered(long nodeReference, long reference, Read read) {
        if (this.pageCursor == null) {
            this.pageCursor = read.relationshipPage(reference);
        }
        this.setId(-1L);
        this.groupState = GroupState.NONE;
        this.filterState = FilterState.NOT_INITIALIZED;
        this.originNodeReference = nodeReference;
        this.next = reference;
        this.read = read;
    }

    public RelationshipTraversalCursor.Position suspend() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void resume(RelationshipTraversalCursor.Position position) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void neighbour(NodeCursor cursor) {
        this.read.singleNode(this.neighbourNodeReference(), cursor);
    }

    public long neighbourNodeReference() {
        long source = this.sourceNodeReference();
        long target = this.targetNodeReference();
        if (source == this.originNodeReference) {
            return target;
        }
        if (target == this.originNodeReference) {
            return source;
        }
        throw new IllegalStateException("NOT PART OF CHAIN");
    }

    public long originNodeReference() {
        return this.originNodeReference;
    }

    public boolean next() {
        if (this.traversingDenseNode()) {
            this.traverseDenseNode();
        }
        if (this.hasBufferedData()) {
            return this.nextBufferedData();
        }
        if (this.filteringTraversal()) {
            return this.nextFilteredData();
        }
        if (this.next == -1L) {
            this.reset();
            return false;
        }
        this.read.relationship(this, this.next, this.pageCursor);
        this.computeNext();
        return true;
    }

    private boolean nextFilteredData() {
        if (this.next == -1L) {
            this.reset();
            return false;
        }
        if (this.filterState == FilterState.NOT_INITIALIZED) {
            this.read.relationship(this, this.next, this.pageCursor);
            this.filterType = this.getType();
            long source = this.sourceNodeReference();
            long target = this.targetNodeReference();
            if (source == target) {
                this.next = this.getFirstNextRel();
                this.filterState = FilterState.LOOP;
            } else if (source == this.originNodeReference) {
                this.next = this.getFirstNextRel();
                this.filterState = FilterState.OUTGOING;
            } else if (target == this.originNodeReference) {
                this.next = this.getSecondNextRel();
                this.filterState = FilterState.INCOMING;
            }
            return true;
        }
        do {
            this.read.relationship(this, this.next, this.pageCursor);
            this.computeNext();
            if (!this.predicate()) continue;
            return true;
        } while (this.next != -1L);
        this.reset();
        return false;
    }

    private boolean nextBufferedData() {
        this.buffer = this.buffer.next;
        if (!this.hasBufferedData()) {
            this.reset();
            return false;
        }
        this.copyFromBuffer();
        return true;
    }

    private void traverseDenseNode() {
        block5: while (this.next == -1L) {
            switch (this.groupState) {
                case INCOMING: {
                    boolean hasNext = this.group.next();
                    if (!hasNext) {
                        this.reset();
                        return;
                    }
                    this.next = this.group.incomingReference();
                    if (this.pageCursor == null) {
                        this.pageCursor = this.read.relationshipPage(Math.max(this.next, 0L));
                    }
                    this.groupState = GroupState.OUTGOING;
                    continue block5;
                }
                case OUTGOING: {
                    this.next = this.group.outgoingReference();
                    this.groupState = GroupState.LOOP;
                    continue block5;
                }
                case LOOP: {
                    this.next = this.group.loopsReference();
                    this.groupState = GroupState.INCOMING;
                    continue block5;
                }
            }
            throw new IllegalStateException("We cannot get here, but checkstyle forces this!");
        }
    }

    private void computeNext() {
        long source = this.sourceNodeReference();
        long target = this.targetNodeReference();
        if (source == this.originNodeReference) {
            this.next = this.getFirstNextRel();
        } else if (target == this.originNodeReference) {
            this.next = this.getSecondNextRel();
        } else {
            throw new IllegalStateException("NOT PART OF CHAIN");
        }
    }

    private boolean predicate() {
        return this.filterType == this.getType() && this.filterState.check(this.sourceNodeReference(), this.targetNodeReference(), this.originNodeReference);
    }

    private void copyFromBuffer() {
        this.setId(this.buffer.id);
        this.setType(this.buffer.type);
        this.setNextProp(this.buffer.nextProp);
        this.setFirstNode(this.buffer.firstNode);
        this.setSecondNode(this.buffer.secondNode);
    }

    private boolean traversingDenseNode() {
        return this.groupState != GroupState.NONE;
    }

    private boolean filteringTraversal() {
        return this.filterState != FilterState.NONE;
    }

    public boolean shouldRetry() {
        return false;
    }

    public void close() {
        if (this.pageCursor != null) {
            this.pageCursor.close();
            this.pageCursor = null;
        }
        this.read = null;
        this.reset();
    }

    private void reset() {
        this.next = -1L;
        this.setId(-1L);
        this.groupState = GroupState.NONE;
        this.filterState = FilterState.NONE;
        this.filterType = -1;
        this.buffer = null;
    }

    public boolean isClosed() {
        return this.pageCursor == null;
    }

    private boolean hasBufferedData() {
        return this.buffer != null;
    }

    static class Record {
        private static final RelationshipRecord DUMMY = null;
        final long id;
        final int type;
        final long nextProp;
        final long firstNode;
        final long secondNode;
        final Record next;

        static Record initialize(Record first) {
            return new Record(DUMMY, first);
        }

        Record(RelationshipRecord record, Record next) {
            if (record != null) {
                this.id = record.getId();
                this.type = record.getType();
                this.nextProp = record.getNextProp();
                this.firstNode = record.getFirstNode();
                this.secondNode = record.getSecondNode();
            } else {
                this.id = -1L;
                this.type = -1;
                this.nextProp = -1L;
                this.firstNode = -1L;
                this.secondNode = -1L;
            }
            this.next = next;
        }
    }

    private static enum FilterState {
        NOT_INITIALIZED{

            @Override
            boolean check(long source, long target, long origin) {
                throw new IllegalStateException("Cannot call check on uninitialized filter");
            }
        }
        ,
        INCOMING{

            @Override
            boolean check(long source, long target, long origin) {
                return origin == target;
            }
        }
        ,
        OUTGOING{

            @Override
            boolean check(long source, long target, long origin) {
                return origin == source;
            }
        }
        ,
        LOOP{

            @Override
            boolean check(long source, long target, long origin) {
                return source == target;
            }
        }
        ,
        NONE{

            @Override
            boolean check(long source, long target, long origin) {
                return true;
            }
        };


        abstract boolean check(long var1, long var3, long var5);
    }

    private static enum GroupState {
        INCOMING,
        OUTGOING,
        LOOP,
        NONE;

    }
}

