/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.store.AllIdIterator;
import org.neo4j.kernel.impl.api.store.StoreIteratorRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StoreNodeRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.api.store.StoreSingleNodeCursor;
import org.neo4j.kernel.impl.api.store.StoreSinglePropertyCursor;
import org.neo4j.kernel.impl.api.store.StoreSingleRelationshipCursor;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandCreationContext;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class StoreStatement
implements StorageStatement {
    private final InstanceCache<StoreSingleNodeCursor> singleNodeCursor;
    private final InstanceCache<StoreSingleRelationshipCursor> singleRelationshipCursor;
    private final InstanceCache<StoreIteratorRelationshipCursor> iteratorRelationshipCursor;
    private final InstanceCache<StoreNodeRelationshipCursor> nodeRelationshipsCursor;
    private final InstanceCache<StoreSinglePropertyCursor> singlePropertyCursorCache;
    private final InstanceCache<StorePropertyCursor> propertyCursorCache;
    private final NeoStores neoStores;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final RelationshipGroupStore relationshipGroupStore;
    private final PropertyStore propertyStore;
    private final Supplier<IndexReaderFactory> indexReaderFactorySupplier;
    private final RecordCursors recordCursors;
    private final Supplier<LabelScanReader> labelScanStore;
    private final RecordStorageCommandCreationContext commandCreationContext;
    private final DynamicArrayStore propertyArrayStore;
    private final DynamicStringStore propertyStringStore;
    private IndexReaderFactory indexReaderFactory;
    private LabelScanReader labelScanReader;
    private boolean acquired;
    private boolean closed;
    private final Nodes nodes;
    private final Relationships relationships;
    private final Groups groups;
    private final Properties properties;

    public StoreStatement(NeoStores neoStores, Supplier<IndexReaderFactory> indexReaderFactory, Supplier<LabelScanReader> labelScanReaderSupplier, final LockService lockService, RecordStorageCommandCreationContext commandCreationContext) {
        this.neoStores = neoStores;
        this.indexReaderFactorySupplier = indexReaderFactory;
        this.labelScanStore = labelScanReaderSupplier;
        this.commandCreationContext = commandCreationContext;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.propertyStore = neoStores.getPropertyStore();
        this.propertyArrayStore = this.propertyStore.getArrayStore();
        this.propertyStringStore = this.propertyStore.getStringStore();
        this.recordCursors = new RecordCursors(neoStores);
        this.singleNodeCursor = new InstanceCache<StoreSingleNodeCursor>(){

            @Override
            protected StoreSingleNodeCursor create() {
                return new StoreSingleNodeCursor((NodeRecord)StoreStatement.this.nodeStore.newRecord(), this, StoreStatement.this.recordCursors, lockService);
            }
        };
        this.singleRelationshipCursor = new InstanceCache<StoreSingleRelationshipCursor>(){

            @Override
            protected StoreSingleRelationshipCursor create() {
                return new StoreSingleRelationshipCursor((RelationshipRecord)StoreStatement.this.relationshipStore.newRecord(), this, StoreStatement.this.recordCursors, lockService);
            }
        };
        this.iteratorRelationshipCursor = new InstanceCache<StoreIteratorRelationshipCursor>(){

            @Override
            protected StoreIteratorRelationshipCursor create() {
                return new StoreIteratorRelationshipCursor((RelationshipRecord)StoreStatement.this.relationshipStore.newRecord(), this, StoreStatement.this.recordCursors, lockService);
            }
        };
        this.nodeRelationshipsCursor = new InstanceCache<StoreNodeRelationshipCursor>(){

            @Override
            protected StoreNodeRelationshipCursor create() {
                return new StoreNodeRelationshipCursor((RelationshipRecord)StoreStatement.this.relationshipStore.newRecord(), (RelationshipGroupRecord)StoreStatement.this.relationshipGroupStore.newRecord(), this, StoreStatement.this.recordCursors, lockService);
            }
        };
        this.singlePropertyCursorCache = new InstanceCache<StoreSinglePropertyCursor>(){

            @Override
            protected StoreSinglePropertyCursor create() {
                return new StoreSinglePropertyCursor(StoreStatement.this.recordCursors, this);
            }
        };
        this.propertyCursorCache = new InstanceCache<StorePropertyCursor>(){

            @Override
            protected StorePropertyCursor create() {
                return new StorePropertyCursor(StoreStatement.this.recordCursors, this);
            }
        };
        this.nodes = new Nodes();
        this.relationships = new Relationships();
        this.groups = new Groups();
        this.properties = new Properties();
    }

    @Override
    public void acquire() {
        assert (!this.closed);
        assert (!this.acquired);
        this.acquired = true;
    }

    @Override
    public Cursor<NodeItem> acquireSingleNodeCursor(long nodeId) {
        this.neoStores.assertOpen();
        return this.singleNodeCursor.get().init(nodeId);
    }

    @Override
    public Cursor<RelationshipItem> acquireSingleRelationshipCursor(long relId) {
        this.neoStores.assertOpen();
        return this.singleRelationshipCursor.get().init(relId);
    }

    @Override
    public Cursor<RelationshipItem> acquireNodeRelationshipCursor(boolean isDense, long nodeId, long relationshipId, Direction direction, IntPredicate relTypeFilter) {
        this.neoStores.assertOpen();
        return this.nodeRelationshipsCursor.get().init(isDense, relationshipId, nodeId, direction, relTypeFilter);
    }

    @Override
    public Cursor<RelationshipItem> relationshipsGetAllCursor() {
        this.neoStores.assertOpen();
        return this.iteratorRelationshipCursor.get().init((PrimitiveLongIterator)new AllIdIterator(this.relationshipStore));
    }

    @Override
    public Cursor<PropertyItem> acquirePropertyCursor(long propertyId, Lock lock, AssertOpen assertOpen) {
        return this.propertyCursorCache.get().init(propertyId, lock, assertOpen);
    }

    @Override
    public Cursor<PropertyItem> acquireSinglePropertyCursor(long propertyId, int propertyKeyId, Lock lock, AssertOpen assertOpen) {
        return this.singlePropertyCursorCache.get().init(propertyId, propertyKeyId, lock, assertOpen);
    }

    @Override
    public void release() {
        assert (!this.closed);
        assert (this.acquired);
        this.closeSchemaResources();
        this.acquired = false;
    }

    @Override
    public void close() {
        assert (!this.closed);
        this.closeSchemaResources();
        this.recordCursors.close();
        this.commandCreationContext.close();
        this.closed = true;
    }

    private void closeSchemaResources() {
        if (this.indexReaderFactory != null) {
            this.indexReaderFactory.close();
        }
        if (this.labelScanReader != null) {
            this.labelScanReader.close();
            this.labelScanReader = null;
        }
    }

    @Override
    public LabelScanReader getLabelScanReader() {
        return this.labelScanReader != null ? this.labelScanReader : (this.labelScanReader = this.labelScanStore.get());
    }

    private IndexReaderFactory indexReaderFactory() {
        return this.indexReaderFactory != null ? this.indexReaderFactory : (this.indexReaderFactory = this.indexReaderFactorySupplier.get());
    }

    @Override
    public IndexReader getIndexReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory().newReader(descriptor);
    }

    @Override
    public IndexReader getFreshIndexReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory().newUnCachedReader(descriptor);
    }

    @Override
    public RecordCursors recordCursors() {
        return this.recordCursors;
    }

    RecordStorageCommandCreationContext getCommandCreationContext() {
        return this.commandCreationContext;
    }

    @Override
    public long reserveNode() {
        return this.commandCreationContext.nextId(StoreType.NODE);
    }

    @Override
    public long reserveRelationship() {
        return this.commandCreationContext.nextId(StoreType.RELATIONSHIP);
    }

    @Override
    public Nodes nodes() {
        return this.nodes;
    }

    @Override
    public Relationships relationships() {
        return this.relationships;
    }

    @Override
    public Groups groups() {
        return this.groups;
    }

    @Override
    public Properties properties() {
        return this.properties;
    }

    private static ByteBuffer readDynamic(AbstractDynamicStore store, long reference, ByteBuffer buffer, PageCursor page) {
        if (buffer == null) {
            buffer = ByteBuffer.allocate(512);
        } else {
            buffer.clear();
        }
        DynamicRecord record = (DynamicRecord)store.newRecord();
        do {
            store.getRecordByCursor(reference, record, RecordLoad.FORCE, page);
            reference = record.getNextBlock();
            byte[] data = record.getData();
            if (buffer.remaining() < data.length) {
                buffer = StoreStatement.grow(buffer, data.length);
            }
            buffer.put(data, 0, data.length);
        } while (reference != -1L);
        return buffer;
    }

    private static ByteBuffer grow(ByteBuffer buffer, int required) {
        buffer.flip();
        int capacity = buffer.capacity();
        while ((capacity *= 2) - buffer.limit() < required) {
        }
        return ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN).put(buffer);
    }

    private static <R extends AbstractBaseRecord> RecordCursor<R> newCursor(RecordStore<R> store) {
        return store.newRecordCursor(store.newRecord()).acquire(store.getNumberOfReservedLowIds(), RecordLoad.NORMAL);
    }

    class Properties
    implements StorageStatement.Properties {
        Properties() {
        }

        @Override
        public PageCursor openPageCursor(long reference) {
            return StoreStatement.this.propertyStore.openPageCursorForReading(reference);
        }

        @Override
        public void loadRecordByCursor(long reference, PropertyRecord propertyBlocks, RecordLoad mode, PageCursor cursor) throws InvalidRecordException {
            StoreStatement.this.propertyStore.getRecordByCursor(reference, propertyBlocks, mode, cursor);
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return StoreStatement.this.propertyStore.getHighestPossibleIdInUse();
        }

        @Override
        public PageCursor openStringPageCursor(long reference) {
            return StoreStatement.this.propertyStringStore.openPageCursorForReading(reference);
        }

        @Override
        public PageCursor openArrayPageCursor(long reference) {
            return StoreStatement.this.propertyArrayStore.openPageCursorForReading(reference);
        }

        @Override
        public ByteBuffer loadString(long reference, ByteBuffer buffer, PageCursor page) {
            return StoreStatement.readDynamic(StoreStatement.this.propertyStore.getStringStore(), reference, buffer, page);
        }

        @Override
        public ByteBuffer loadArray(long reference, ByteBuffer buffer, PageCursor page) {
            return StoreStatement.readDynamic(StoreStatement.this.propertyStore.getArrayStore(), reference, buffer, page);
        }
    }

    class Groups
    implements StorageStatement.Groups {
        Groups() {
        }

        @Override
        public PageCursor openPageCursor(long reference) {
            return StoreStatement.this.relationshipGroupStore.openPageCursorForReading(reference);
        }

        @Override
        public void loadRecordByCursor(long reference, RelationshipGroupRecord relationshipGroupRecord, RecordLoad mode, PageCursor cursor) throws InvalidRecordException {
            StoreStatement.this.relationshipGroupStore.getRecordByCursor(reference, relationshipGroupRecord, mode, cursor);
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return StoreStatement.this.relationshipGroupStore.getHighestPossibleIdInUse();
        }
    }

    class Relationships
    implements StorageStatement.Relationships {
        Relationships() {
        }

        @Override
        public PageCursor openPageCursor(long reference) {
            return StoreStatement.this.relationshipStore.openPageCursorForReading(reference);
        }

        @Override
        public void loadRecordByCursor(long reference, RelationshipRecord relationshipRecord, RecordLoad mode, PageCursor cursor) throws InvalidRecordException {
            StoreStatement.this.relationshipStore.getRecordByCursor(reference, relationshipRecord, mode, cursor);
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return StoreStatement.this.relationshipStore.getHighestPossibleIdInUse();
        }
    }

    class Nodes
    implements StorageStatement.Nodes {
        Nodes() {
        }

        @Override
        public PageCursor openPageCursor(long reference) {
            return StoreStatement.this.nodeStore.openPageCursorForReading(reference);
        }

        @Override
        public void loadRecordByCursor(long reference, NodeRecord nodeRecord, RecordLoad mode, PageCursor cursor) throws InvalidRecordException {
            StoreStatement.this.nodeStore.getRecordByCursor(reference, nodeRecord, mode, cursor);
        }

        @Override
        public long getHighestPossibleIdInUse() {
            return StoreStatement.this.nodeStore.getHighestPossibleIdInUse();
        }

        @Override
        public RecordCursor<DynamicRecord> newLabelCursor() {
            return StoreStatement.newCursor(StoreStatement.this.nodeStore.getDynamicLabelStore());
        }
    }
}

