/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class RelationshipProxy
implements Relationship,
RelationshipVisitor<RuntimeException> {
    private final EmbeddedProxySPI actions;
    private long id = -1L;
    private long startNode = -1L;
    private long endNode = -1L;
    private int type;

    public RelationshipProxy(EmbeddedProxySPI spi, long id, long startNode, int type, long endNode) {
        this.actions = spi;
        this.visit(id, type, startNode, endNode);
    }

    public RelationshipProxy(EmbeddedProxySPI spi, long id) {
        this.actions = spi;
        this.id = id;
    }

    @Override
    public final void visit(long id, int type, long startNode, long endNode) throws RuntimeException {
        this.id = id;
        this.type = type;
        this.startNode = startNode;
        this.endNode = endNode;
    }

    private void initializeData() {
        if (this.startNode == -1L) {
            try (Statement statement = this.actions.statement();){
                statement.readOperations().relationshipVisit(this.getId(), this);
            }
            catch (EntityNotFoundException e) {
                throw new NotFoundException((Throwable)e);
            }
        }
    }

    public long getId() {
        return this.id;
    }

    private int typeId() {
        this.initializeData();
        return this.type;
    }

    private long sourceId() {
        this.initializeData();
        return this.startNode;
    }

    private long targetId() {
        this.initializeData();
        return this.endNode;
    }

    public GraphDatabaseService getGraphDatabase() {
        return this.actions.getGraphDatabase();
    }

    public void delete() {
        KernelTransaction transaction = this.safeAcquireTransaction();
        try {
            boolean deleted = transaction.dataWrite().relationshipDelete(this.id);
            if (!deleted) {
                throw new NotFoundException("Unable to delete relationship[" + this.getId() + "] since it is already deleted.");
            }
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while deleting the relationship: " + e.getMessage(), e);
        }
    }

    public Node[] getNodes() {
        this.assertInUnterminatedTransaction();
        return new Node[]{this.actions.newNodeProxy(this.sourceId()), this.actions.newNodeProxy(this.targetId())};
    }

    public Node getOtherNode(Node node) {
        this.assertInUnterminatedTransaction();
        return this.actions.newNodeProxy(this.getOtherNodeId(node.getId()));
    }

    public Node getStartNode() {
        this.assertInUnterminatedTransaction();
        return this.actions.newNodeProxy(this.sourceId());
    }

    public Node getEndNode() {
        this.assertInUnterminatedTransaction();
        return this.actions.newNodeProxy(this.targetId());
    }

    public long getStartNodeId() {
        return this.sourceId();
    }

    public long getEndNodeId() {
        return this.targetId();
    }

    public long getOtherNodeId(long id) {
        long start = this.sourceId();
        long end = this.targetId();
        if (start == id) {
            return end;
        }
        if (end == id) {
            return start;
        }
        throw new NotFoundException("Node[" + id + "] not connected to this relationship[" + this.getId() + "]");
    }

    public RelationshipType getType() {
        this.assertInUnterminatedTransaction();
        return this.actions.getRelationshipTypeById(this.typeId());
    }

    public Iterable<String> getPropertyKeys() {
        KernelTransaction transaction = this.safeAcquireTransaction();
        ArrayList<String> keys = new ArrayList<String>();
        try {
            RelationshipScanCursor relationships = transaction.relationshipCursor();
            PropertyCursor properties = transaction.propertyCursor();
            this.singleRelationship(transaction, relationships);
            TokenRead token = transaction.tokenRead();
            relationships.properties(properties);
            while (properties.next()) {
                keys.add(token.propertyKeyName(properties.propertyKey()));
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return keys;
    }

    public Map<String, Object> getProperties(String ... keys) {
        Objects.requireNonNull(keys, "Properties keys should be not null array.");
        if (keys.length == 0) {
            return Collections.emptyMap();
        }
        KernelTransaction transaction = this.safeAcquireTransaction();
        int itemsToReturn = keys.length;
        HashMap<String, Object> properties = new HashMap<String, Object>(itemsToReturn);
        TokenRead token = transaction.tokenRead();
        int[] propertyIds = new int[itemsToReturn];
        for (int i = 0; i < itemsToReturn; ++i) {
            String key = keys[i];
            if (key == null) {
                throw new NullPointerException(String.format("Key %d was null", i));
            }
            propertyIds[i] = token.propertyKey(key);
        }
        RelationshipScanCursor relationships = transaction.relationshipCursor();
        PropertyCursor propertyCursor = transaction.propertyCursor();
        this.singleRelationship(transaction, relationships);
        relationships.properties(propertyCursor);
        int propertiesToFind = itemsToReturn;
        block1: while (propertiesToFind > 0 && propertyCursor.next()) {
            int currentKey = propertyCursor.propertyKey();
            for (int i = 0; i < itemsToReturn; ++i) {
                if (propertyIds[i] != currentKey) continue;
                properties.put(keys[i], propertyCursor.propertyValue().asObjectCopy());
                --propertiesToFind;
                continue block1;
            }
        }
        return properties;
    }

    public Map<String, Object> getAllProperties() {
        KernelTransaction transaction = this.safeAcquireTransaction();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        try {
            RelationshipScanCursor relationships = transaction.relationshipCursor();
            PropertyCursor propertyCursor = transaction.propertyCursor();
            TokenRead token = transaction.tokenRead();
            this.singleRelationship(transaction, relationships);
            relationships.properties(propertyCursor);
            while (propertyCursor.next()) {
                properties.put(token.propertyKeyName(propertyCursor.propertyKey()), propertyCursor.propertyValue().asObjectCopy());
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return properties;
    }

    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        KernelTransaction transaction = this.safeAcquireTransaction();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            throw new NotFoundException(String.format("No such property, '%s'.", key));
        }
        RelationshipScanCursor relationships = transaction.relationshipCursor();
        PropertyCursor properties = transaction.propertyCursor();
        this.singleRelationship(transaction, relationships);
        relationships.properties(properties);
        while (properties.next()) {
            if (propertyKey != properties.propertyKey()) continue;
            Value value = properties.propertyValue();
            if (value == Values.NO_VALUE) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            return value.asObjectCopy();
        }
        throw new NotFoundException(String.format("No such property, '%s'.", key));
    }

    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        KernelTransaction transaction = this.safeAcquireTransaction();
        RelationshipScanCursor relationships = transaction.relationshipCursor();
        PropertyCursor properties = transaction.propertyCursor();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return defaultValue;
        }
        this.singleRelationship(transaction, relationships);
        relationships.properties(properties);
        while (properties.next()) {
            if (propertyKey != properties.propertyKey()) continue;
            Value value = properties.propertyValue();
            return value == Values.NO_VALUE ? defaultValue : value.asObjectCopy();
        }
        return defaultValue;
    }

    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        KernelTransaction transaction = this.safeAcquireTransaction();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return false;
        }
        RelationshipScanCursor relationships = transaction.relationshipCursor();
        PropertyCursor properties = transaction.propertyCursor();
        this.singleRelationship(transaction, relationships);
        relationships.properties(properties);
        while (properties.next()) {
            if (propertyKey != properties.propertyKey()) continue;
            return true;
        }
        return false;
    }

    public void setProperty(String key, Object value) {
        int propertyKeyId;
        KernelTransaction transaction = this.actions.kernelTransaction();
        try {
            propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        try (Statement ignore = transaction.acquireStatement();){
            transaction.dataWrite().relationshipSetProperty(this.id, propertyKeyId, Values.of((Object)value, (boolean)false));
        }
        catch (IllegalArgumentException e) {
            this.actions.failTransaction();
            throw e;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while setting property: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object removeProperty(String key) {
        KernelTransaction transaction = this.actions.kernelTransaction();
        try (Statement ignore = transaction.acquireStatement();){
            int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
            Object object = transaction.dataWrite().relationshipRemoveProperty(this.id, propertyKeyId).asObjectCopy();
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException((Throwable)e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while removing property: " + e.getMessage(), e);
        }
    }

    public boolean isType(RelationshipType type) {
        this.assertInUnterminatedTransaction();
        return this.actions.getRelationshipTypeById(this.typeId()).name().equals(type.name());
    }

    public int compareTo(Object rel) {
        Relationship r = (Relationship)rel;
        return Long.compare(this.getId(), r.getId());
    }

    public boolean equals(Object o) {
        return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.getId() >>> 32 ^ this.getId());
    }

    public String toString() {
        try {
            String relType = this.actions.getRelationshipTypeById(this.typeId()).name();
            return String.format("(%d)-[%s,%d]->(%d)", this.sourceId(), relType, this.getId(), this.targetId());
        }
        catch (DatabaseShutdownException | NotInTransactionException throwable) {
            String relType = "RELTYPE(" + this.type + ")";
            return String.format("(?)-[%s,%d]->(?)", relType, this.getId());
        }
    }

    private KernelTransaction safeAcquireTransaction() {
        KernelTransaction transaction = this.actions.kernelTransaction();
        if (transaction.isTerminated()) {
            Status terminationReason = transaction.getReasonIfTerminated().orElse((Status)Status.Transaction.Terminated);
            throw new TransactionTerminatedException(terminationReason);
        }
        return transaction;
    }

    private void singleRelationship(KernelTransaction transaction, RelationshipScanCursor relationships) {
        transaction.dataRead().singleRelationship(this.id, relationships);
        if (!relationships.next()) {
            throw new NotFoundException((Throwable)new EntityNotFoundException(EntityType.RELATIONSHIP, this.id));
        }
    }

    private void assertInUnterminatedTransaction() {
        this.actions.assertInUnterminatedTransaction();
    }
}

