/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.values.storable.ValueGroup;

class CapabilityValidator {
    CapabilityValidator() {
    }

    static void validateQuery(IndexCapability capability, IndexOrder indexOrder, IndexQuery[] predicates) {
        if (indexOrder != IndexOrder.NONE) {
            ValueGroup valueGroup = predicates[0].valueGroup();
            Object[] orderCapability = capability.orderCapability(new ValueGroup[]{valueGroup});
            if (!ArrayUtil.contains(orderCapability, indexOrder)) {
                orderCapability = (IndexOrder[])ArrayUtils.add((Object[])orderCapability, (Object)IndexOrder.NONE);
                throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. Supported orders for query %s are %s.", indexOrder, Arrays.toString(predicates), Arrays.toString(orderCapability)));
            }
        }
    }
}

