/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexHeaderReader;

public class NativeSchemaIndexes {
    private NativeSchemaIndexes() {
    }

    public static InternalIndexState readState(PageCache pageCache, File indexFile, Layout<?, ?> layout) throws IOException {
        NativeSchemaIndexHeaderReader headerReader = new NativeSchemaIndexHeaderReader();
        GBPTree.readHeader((PageCache)pageCache, (File)indexFile, layout, (Header.Reader)headerReader);
        switch (headerReader.state) {
            case 0: {
                return InternalIndexState.FAILED;
            }
            case 1: {
                return InternalIndexState.ONLINE;
            }
            case 2: {
                return InternalIndexState.POPULATING;
            }
        }
        throw new IllegalStateException("Unexpected initial state byte value " + headerReader.state);
    }

    public static String readFailureMessage(PageCache pageCache, File indexFile, Layout<?, ?> layout) throws IOException {
        NativeSchemaIndexHeaderReader headerReader = new NativeSchemaIndexHeaderReader();
        GBPTree.readHeader((PageCache)pageCache, (File)indexFile, layout, (Header.Reader)headerReader);
        return headerReader.failureMessage;
    }
}

