/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexValueCapability;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NumberLayoutNonUnique;
import org.neo4j.kernel.impl.index.schema.NumberLayoutUnique;
import org.neo4j.kernel.impl.index.schema.NumberSchemaIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NumberSchemaKey;
import org.neo4j.values.storable.ValueGroup;

public class NumberSchemaIndexProvider
extends NativeSchemaIndexProvider<NumberSchemaKey, NativeSchemaValue> {
    public static final String KEY = "native";
    public static final SchemaIndexProvider.Descriptor NATIVE_PROVIDER_DESCRIPTOR = new SchemaIndexProvider.Descriptor("native", "1.0");
    static final IndexCapability CAPABILITY = new NumberIndexCapability();

    public NumberSchemaIndexProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory directoryStructure, SchemaIndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(NATIVE_PROVIDER_DESCRIPTOR, 0, directoryStructure, pageCache, fs, monitor, recoveryCleanupWorkCollector, readOnly);
    }

    protected NumberLayoutUnique layoutUnique() {
        return new NumberLayoutUnique();
    }

    protected NumberLayoutNonUnique layoutNonUnique() {
        return new NumberLayoutNonUnique();
    }

    @Override
    protected IndexAccessor newIndexAccessor(File storeFile, Layout<NumberSchemaKey, NativeSchemaValue> layout, IndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig) throws IOException {
        return new NumberSchemaIndexAccessor(this.pageCache, this.fs, storeFile, layout, this.recoveryCleanupWorkCollector, this.monitor, descriptor, indexId, samplingConfig);
    }

    @Override
    public IndexCapability getCapability(IndexDescriptor indexDescriptor) {
        return CAPABILITY;
    }

    private static class NumberIndexCapability
    implements IndexCapability {
        private static final IndexOrder[] SUPPORTED_ORDER = new IndexOrder[]{IndexOrder.ASCENDING};
        private static final IndexOrder[] EMPTY_ORDER = new IndexOrder[0];

        private NumberIndexCapability() {
        }

        public IndexOrder[] orderCapability(ValueGroup ... valueGroups) {
            if (this.support(valueGroups)) {
                return SUPPORTED_ORDER;
            }
            return EMPTY_ORDER;
        }

        public IndexValueCapability valueCapability(ValueGroup ... valueGroups) {
            if (this.support(valueGroups)) {
                return IndexValueCapability.YES;
            }
            if (this.singleWildcard(valueGroups)) {
                return IndexValueCapability.PARTIAL;
            }
            return IndexValueCapability.NO;
        }

        private boolean singleWildcard(ValueGroup[] valueGroups) {
            return valueGroups.length == 1 && valueGroups[0] == ValueGroup.UNKNOWN;
        }

        private boolean support(ValueGroup[] valueGroups) {
            return valueGroups.length == 1 && valueGroups[0] == ValueGroup.NUMBER;
        }
    }
}

