/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.StringSchemaKey;

abstract class StringLayout
extends Layout.Adapter<StringSchemaKey, NativeSchemaValue> {
    StringLayout() {
    }

    public StringSchemaKey newKey() {
        return new StringSchemaKey();
    }

    public StringSchemaKey copyKey(StringSchemaKey key, StringSchemaKey into) {
        into.bytes = (byte[])key.bytes.clone();
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    public NativeSchemaValue newValue() {
        return NativeSchemaValue.INSTANCE;
    }

    public int keySize(StringSchemaKey key) {
        return key.size();
    }

    public int valueSize(NativeSchemaValue value) {
        return 0;
    }

    public void writeKey(PageCursor cursor, StringSchemaKey key) {
        cursor.putLong(key.getEntityId());
        cursor.putBytes(key.bytes);
    }

    public void writeValue(PageCursor cursor, NativeSchemaValue value) {
    }

    public void readKey(PageCursor cursor, StringSchemaKey into, int keySize) {
        if (keySize < 8) {
            into.bytes = null;
            return;
        }
        into.setEntityId(cursor.getLong());
        into.bytes = new byte[keySize - 8];
        cursor.getBytes(into.bytes);
    }

    public void readValue(PageCursor cursor, NativeSchemaValue into, int valueSize) {
    }

    public boolean fixedSize() {
        return false;
    }

    public String toString() {
        return String.format("%s[version:%d.%d, identifier:%d]", ((Object)((Object)this)).getClass().getSimpleName(), this.majorVersion(), this.minorVersion(), this.identifier());
    }
}

