/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.DateSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.TemporalIndexFiles;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPartReader;
import org.neo4j.kernel.impl.index.schema.TemporalIndexReader;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUtils;
import org.neo4j.storageengine.api.schema.IndexReader;

class TemporalIndexAccessor
extends TemporalIndexCache<PartAccessor<?>, IOException>
implements IndexAccessor {
    private final IndexDescriptor descriptor;

    TemporalIndexAccessor(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, PageCache pageCache, FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, SchemaIndexProvider.Monitor monitor, TemporalIndexFiles temporalIndexFiles) throws IOException {
        super(new PartFactory(pageCache, fs, recoveryCleanupWorkCollector, monitor, descriptor, indexId, samplingConfig, temporalIndexFiles));
        this.descriptor = descriptor;
        temporalIndexFiles.loadExistingIndexes(this);
    }

    @Override
    public void drop() throws IOException {
        FusionIndexUtils.forAll(NativeSchemaIndexAccessor::drop, this);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return new IndexUpdater(){

            @Override
            public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
                throw new UnsupportedOperationException("Not yet");
            }

            @Override
            public void close() throws IOException, IndexEntryConflictException {
            }
        };
    }

    @Override
    public void force(IOLimiter ioLimiter) throws IOException {
        for (NativeSchemaIndexAccessor part : this) {
            part.force(ioLimiter);
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() throws IOException {
        FusionIndexUtils.forAll(NativeSchemaIndexAccessor::close, this);
    }

    @Override
    public IndexReader newReader() {
        return new TemporalIndexReader(this.descriptor, this);
    }

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        final ArrayList<BoundedIterable<Long>> allEntriesReader = new ArrayList<BoundedIterable<Long>>();
        for (NativeSchemaIndexAccessor part : this) {
            allEntriesReader.add(part.newAllEntriesReader());
        }
        return new BoundedIterable<Long>(){

            @Override
            public long maxCount() {
                long sum = 0L;
                for (BoundedIterable part : allEntriesReader) {
                    long partMaxCount = part.maxCount();
                    if (partMaxCount == -1L) {
                        return -1L;
                    }
                    sum += partMaxCount;
                }
                return sum;
            }

            @Override
            public void close() throws Exception {
                FusionIndexUtils.forAll(AutoCloseable::close, allEntriesReader);
            }

            @Override
            public Iterator<Long> iterator() {
                return new CombiningIterable((Iterable)allEntriesReader).iterator();
            }
        };
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        ArrayList<ResourceIterator<File>> snapshotFiles = new ArrayList<ResourceIterator<File>>();
        for (NativeSchemaIndexAccessor part : this) {
            snapshotFiles.add(part.snapshotFiles());
        }
        return Iterators.concatResourceIterators(snapshotFiles.iterator());
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) {
    }

    @Override
    public boolean isDirty() {
        return Iterators.stream(this.iterator()).anyMatch(NativeSchemaIndexAccessor::isDirty);
    }

    static class PartFactory
    implements TemporalIndexCache.Factory<PartAccessor<?>, IOException> {
        private final PageCache pageCache;
        private final FileSystemAbstraction fs;
        private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
        private final SchemaIndexProvider.Monitor monitor;
        private final IndexDescriptor descriptor;
        private final long indexId;
        private final IndexSamplingConfig samplingConfig;
        private final TemporalIndexFiles temporalIndexFiles;

        PartFactory(PageCache pageCache, FileSystemAbstraction fs, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, SchemaIndexProvider.Monitor monitor, IndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig, TemporalIndexFiles temporalIndexFiles) {
            this.pageCache = pageCache;
            this.fs = fs;
            this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
            this.monitor = monitor;
            this.descriptor = descriptor;
            this.indexId = indexId;
            this.samplingConfig = samplingConfig;
            this.temporalIndexFiles = temporalIndexFiles;
        }

        @Override
        public PartAccessor<?> newDate() throws IOException {
            return new PartAccessor<DateSchemaKey>(this.pageCache, this.fs, this.temporalIndexFiles.date(), this.recoveryCleanupWorkCollector, this.monitor, this.descriptor, this.indexId, this.samplingConfig);
        }

        @Override
        public PartAccessor<?> newDateTime() throws IOException {
            throw new UnsupportedOperationException("no comprende");
        }

        @Override
        public PartAccessor<?> newDateTimeZoned() throws IOException {
            throw new UnsupportedOperationException("no comprende");
        }

        @Override
        public PartAccessor<?> newTime() throws IOException {
            throw new UnsupportedOperationException("no comprende");
        }

        @Override
        public PartAccessor<?> newTimeZoned() throws IOException {
            throw new UnsupportedOperationException("no comprende");
        }

        @Override
        public PartAccessor<?> newDuration() throws IOException {
            throw new UnsupportedOperationException("no comprende");
        }
    }

    static class PartAccessor<KEY extends NativeSchemaKey>
    extends NativeSchemaIndexAccessor<KEY, NativeSchemaValue> {
        private final Layout<KEY, NativeSchemaValue> layout;
        private final IndexDescriptor descriptor;
        private final IndexSamplingConfig samplingConfig;

        PartAccessor(PageCache pageCache, FileSystemAbstraction fs, TemporalIndexFiles.FileLayout<KEY> fileLayout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, SchemaIndexProvider.Monitor monitor, IndexDescriptor descriptor, long indexId, IndexSamplingConfig samplingConfig) throws IOException {
            super(pageCache, fs, fileLayout.indexFile, fileLayout.layout, recoveryCleanupWorkCollector, monitor, descriptor, indexId, samplingConfig);
            this.layout = fileLayout.layout;
            this.descriptor = descriptor;
            this.samplingConfig = samplingConfig;
        }

        @Override
        public TemporalIndexPartReader<KEY> newReader() {
            return new TemporalIndexPartReader<KEY>(this.tree, this.layout, this.samplingConfig, this.descriptor);
        }
    }
}

