/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.index.schema.NativePopulatingUpdater;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPopulator;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUtils;

public class TemporalIndexPopulatingUpdater
extends TemporalIndexCache<NativePopulatingUpdater, IOException>
implements IndexUpdater {
    TemporalIndexPopulatingUpdater(TemporalIndexPopulator populator, PropertyAccessor propertyAccessor) {
        super(new PartFactory(populator, propertyAccessor));
    }

    @Override
    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
        switch (update.updateMode()) {
            case ADDED: {
                ((NativePopulatingUpdater)this.select(update.values()[0].valueGroup())).process(update);
                break;
            }
            case CHANGED: {
                NativePopulatingUpdater from = (NativePopulatingUpdater)this.select(update.beforeValues()[0].valueGroup());
                NativePopulatingUpdater to = (NativePopulatingUpdater)this.select(update.values()[0].valueGroup());
                if (from == to) {
                    from.process(update);
                    break;
                }
                from.process(IndexEntryUpdate.remove(update.getEntityId(), update.indexKey(), update.beforeValues()));
                to.process(IndexEntryUpdate.add(update.getEntityId(), update.indexKey(), update.values()));
                break;
            }
            case REMOVED: {
                ((NativePopulatingUpdater)this.select(update.values()[0].valueGroup())).process(update);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        FusionIndexUtils.forAll(NativePopulatingUpdater::close, this);
    }

    static class PartFactory
    implements TemporalIndexCache.Factory<NativePopulatingUpdater, IOException> {
        private final TemporalIndexPopulator populator;
        private PropertyAccessor propertyAccessor;

        PartFactory(TemporalIndexPopulator populator, PropertyAccessor propertyAccessor) {
            this.populator = populator;
            this.propertyAccessor = propertyAccessor;
        }

        @Override
        public NativePopulatingUpdater newDate() throws IOException {
            return ((TemporalIndexPopulator.PartPopulator)this.populator.date()).newPopulatingUpdater(this.propertyAccessor);
        }

        @Override
        public NativePopulatingUpdater newDateTime() throws IOException {
            throw new UnsupportedOperationException("too tired to write");
        }

        @Override
        public NativePopulatingUpdater newDateTimeZoned() throws IOException {
            throw new UnsupportedOperationException("too tired to write");
        }

        @Override
        public NativePopulatingUpdater newTime() throws IOException {
            throw new UnsupportedOperationException("too tired to write");
        }

        @Override
        public NativePopulatingUpdater newTimeZoned() throws IOException {
            throw new UnsupportedOperationException("too tired to write");
        }

        @Override
        public NativePopulatingUpdater newDuration() throws IOException {
            throw new UnsupportedOperationException("too tired to write");
        }
    }
}

