/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.SpatialCRSSchemaIndex;
import org.neo4j.kernel.impl.index.schema.fusion.SpatialFusionIndexAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.SpatialFusionIndexPopulator;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class SpatialFusionSchemaIndexProvider
extends SchemaIndexProvider
implements SpatialCRSSchemaIndex.Supplier {
    public static final String KEY = "spatial";
    public static final SchemaIndexProvider.Descriptor SPATIAL_PROVIDER_DESCRIPTOR = new SchemaIndexProvider.Descriptor("spatial", "1.0");
    private static final Pattern CRS_DIR_PATTERN = Pattern.compile("(\\d+)-(\\d+)");
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final SchemaIndexProvider.Monitor monitor;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final boolean readOnly;
    private Map<Long, Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex>> indexes = new HashMap<Long, Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex>>();

    public SpatialFusionSchemaIndexProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory directoryStructure, SchemaIndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(SPATIAL_PROVIDER_DESCRIPTOR, 0, directoryStructure);
        this.pageCache = pageCache;
        this.fs = fs;
        this.monitor = monitor;
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.readOnly = readOnly;
    }

    @Override
    public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        return new SpatialFusionIndexPopulator(this.indexesFor(indexId), indexId, descriptor, samplingConfig, this);
    }

    @Override
    public IndexAccessor getOnlineAccessor(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        return new SpatialFusionIndexAccessor(this.indexesFor(indexId), indexId, descriptor, samplingConfig, this);
    }

    Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex> indexesFor(long indexId) {
        return this.indexes.computeIfAbsent(indexId, k -> new HashMap());
    }

    @Override
    public String getPopulationFailure(long indexId, IndexDescriptor descriptor) throws IllegalStateException {
        try {
            for (SpatialCRSSchemaIndex index : this.indexesFor(indexId).values()) {
                String indexFailure = index.readPopulationFailure(descriptor);
                if (indexFailure == null) continue;
                return indexFailure;
            }
            throw new IllegalStateException("Index " + indexId + " isn't failed");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InternalIndexState getInitialState(long indexId, IndexDescriptor descriptor) {
        Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex> indexMap = this.indexesFor(indexId);
        this.findAndCreateSpatialIndex(indexMap, indexId, descriptor);
        InternalIndexState state = InternalIndexState.ONLINE;
        for (SpatialCRSSchemaIndex index : indexMap.values()) {
            try {
                switch (index.readState(descriptor)) {
                    case FAILED: {
                        return InternalIndexState.FAILED;
                    }
                    case POPULATING: {
                        state = InternalIndexState.POPULATING;
                    }
                }
            }
            catch (IOException e) {
                this.monitor.failedToOpenIndex(indexId, descriptor, "Requesting re-population.", e);
                state = InternalIndexState.POPULATING;
            }
        }
        return state;
    }

    @Override
    public IndexCapability getCapability(IndexDescriptor indexDescriptor) {
        return IndexCapability.NO_CAPABILITY;
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    @Override
    public SpatialCRSSchemaIndex get(IndexDescriptor descriptor, Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex> indexMap, long indexId, CoordinateReferenceSystem crs) {
        return indexMap.computeIfAbsent(crs, crsKey -> new SpatialCRSSchemaIndex(descriptor, this.directoryStructure(), (CoordinateReferenceSystem)crsKey, indexId, this.pageCache, this.fs, this.monitor, this.recoveryCleanupWorkCollector));
    }

    private void findAndCreateSpatialIndex(Map<CoordinateReferenceSystem, SpatialCRSSchemaIndex> indexMap, long indexId, IndexDescriptor descriptor) {
        File[] crsDirs;
        File directoryForIndex = this.directoryStructure().directoryForIndex(indexId);
        if (directoryForIndex != null && (crsDirs = directoryForIndex.listFiles()) != null) {
            for (File crsDir : crsDirs) {
                int code;
                int tableId;
                CoordinateReferenceSystem crs;
                SpatialCRSSchemaIndex index;
                Matcher m = CRS_DIR_PATTERN.matcher(crsDir.getName());
                if (!m.matches() || (index = this.get(descriptor, indexMap, indexId, crs = CoordinateReferenceSystem.get((int)(tableId = Integer.parseInt(m.group(1))), (int)(code = Integer.parseInt(m.group(2)))))).indexExists()) continue;
                index.markAsFailed("Index file was not found");
            }
        }
    }
}

